#ifndef PHOTON
#define PHOTON

#include "color.h"
#include "geometry.h"

struct photon {
  Point x;    // position
  Spectrum p; // power
  Vector d;   // direction
};

extern int numPhotons;
extern photon map[];
extern int neighbor[];

extern void DebugPhoton();
extern void LaunchPhoton(const Point & p, const Spectrum & power,
			 const float *u);
extern void StorePhoton(Point & p, Spectrum & power, const Vector & dir);
extern void CompactPhoton();
extern int  NearestPhoton(Point & p, float maxNeighborhood);
extern int  RetrievePhotons(Point & p, float & maxNeighborhood,
			    int numNeighbors);
extern void TracePhoton(Spectrum & power, const Ray & ray);

#endif
