
#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "primitives.h"

class Heightfield:public Primitive {
  public:

	Heightfield(int nu, int nv, float *zs, PrimitiveAttributes * a,
				SurfaceFunction * sf);
	~Heightfield();
	virtual bool CanIntersect() const;
	//virtual void Refine(vector < Primitive * >*refined) const;
	virtual BBox BoundObjectSpace() const;
	virtual bool IntersectClosest(const Ray &ray, Float mint, Float *maxt,
				      HitInfo *hit) const;
	virtual bool IntersectTri(const Ray &ray, Float mint, Float *maxt,
				  HitInfo *hit,
				  Point v1, Point v2, Point v3) const;


  private:
	float *z;
	float xSpacing,ySpacing;
	int ntris;
	int nx, ny;
	int x2c(Float x) const { return int(x*(nx-1)); }
	int y2c(Float y) const { return int(y*(ny-1)); }
	Float c2x(Float x) const { return x*xSpacing; }
	Float c2y(Float y) const { return y*ySpacing; }
};

#endif // HEIGHTFIELD_H
