
#ifndef TEXTURE_H
#define TEXTURE_H
#include "lrt.h"
#include "geometry.h"     

class MIPMap {
  public:

	MIPMap(const char *filename);

	int XResolution() const {
		return xResolution;
	} int YResolution() const {
		return yResolution;
	} Spectrum GetTexel(int x, int y, int level) const;

  private:
	 u_char * data;
	int xResolution, yResolution;

};

class TextureMap { public:
	 TextureMap(const char *filename);

	~TextureMap();

	Spectrum Point(int x, int y) const;

	Spectrum Lookup(Float u, Float v) const;

	Spectrum Lookup(Float u, Float v, Float width) const;

	Spectrum Lookup(Float u, Float v, Float dudx, Float dudy,
					Float dvdx, Float dvdy) const;

	unsigned int Type() const { return type; }
	enum {COLOR, BUMP} type;
	friend class SLMachine;
  private:
	 Spectrum * Texture;
	int width, height;

};

class CubeMap {
 public:

     CubeMap(const char *filename_px, const char *filename_nx,
	     const char *filename_py, const char *filename_ny,
	     const char *filename_pz, const char *filename_nz);
     ~CubeMap();

     Spectrum Lookup(Vector v) const;

 private:
     TextureMap* faces[6];
};

#endif // TEXTURE_H
