
#include "texture.h"
#include "color.h"

#define ABS(a) ( (a)<0?-(a):(a) )

TextureMap::TextureMap(const char *filename)
{
  Texture = TIFFRead(filename, &width, &height);
}

TextureMap::~TextureMap()
{
	delete[]Texture;
}

CubeMap::CubeMap(const char* px, const char* nx, const char * py,
		 const char* ny, const char* pz, const char * nz)
{
  faces [0] = new TextureMap(px);
  faces [1] = new TextureMap(nx);
  faces [2] = new TextureMap(py);
  faces [3] = new TextureMap(ny);
  faces [4] = new TextureMap(pz);
  faces [5] = new TextureMap(nz);
}

CubeMap::~CubeMap()
{
  if (faces[0]) delete faces[0];
  if (faces[1]) delete faces[1];
  if (faces[2]) delete faces[2];
  if (faces[3]) delete faces[3];
  if (faces[4]) delete faces[4];
  if (faces[5]) delete faces[5];
}

Spectrum CubeMap::Lookup(Vector v) const
{
  static int cubeTests = 0, cubeHits = 0;
  if (cubeTests==0) StatsRegisterRatio(STATS_DETAILED,"Environment", "Cube Map Tests", &cubeTests, &cubeHits);
  float Z = ABS(v.z);
  float Y = ABS(v.y);
  float X = ABS(v.x);

  float u, w;

  TextureMap* face;

  if (Z > X && Z > Y)
  {
    if (v.z < 0)   // neg z
      face = faces[5];
    else face = faces[4];

    u = v.x / v.z;
    w = v.y / v.z;
    
  }
  else if (X > Y && X > Z)
  {
    if (v.x < 0)  // neg x
      face = faces[1];
    else face = faces[0];

    u = v.y / v.x;
    w = v.z / v.x;
  }
  else
  {
    if (v.y < 0)  // neg y
      face = faces[3];
    else face = faces[2];
    
    u = v.x / v.y;
    w = v.z / v.y;
  }

  u /= 2.;
  w /= 2.;

  u+=0.5;
  w+=0.5;

  u = u;
  w = 1-w;

  cubeTests++;

  return face->Lookup(u,w);
}

Spectrum TextureMap::Point(int x, int y) const
{
  int _x = x % width;
  int _y = y % height;
  return Texture[_y*width + _x];
}

Spectrum TextureMap::Lookup(Float u, Float v) const
{
	Float weights[4];
	if (!Texture)
		return Spectrum(1);

	u = Clamp(u, 0., 1.);
	v = Clamp(v, 0., 1.);

	Float xReal = u * (width - 1);
	Float yReal = v * (height - 1);
	int x = int (xReal);
	int y = int (yReal);

	Float dx = xReal - x;
	Float dy = yReal - y;
	weights[0] = (1. - dx) * (1. - dy);
	weights[1] = (1. - dx) * dy;
	weights[2] = dx * (1. - dy);
	weights[3] = dx * dy;

	Spectrum texels[4];
	texels[0] = Texture[y * width + x];
	if (y < height - 1 && x < width - 1) {
		texels[1] = Texture[(y + 1) * width + x];
		texels[2] = Texture[y * width + x + 1];
		texels[3] = Texture[(y + 1) * width + x + 1];
	} else if (y < height - 1) {
		texels[1] = Texture[(y + 1) * width + x];
		texels[2] = texels[3] = Spectrum(0);
	} else if (x < width - 1) {
		texels[2] = Texture[y * width + x + 1];
		texels[1] = texels[3] = Spectrum(0);
	} else {
		texels[1] = texels[2] = texels[3] = Spectrum(0);
	}

	return weights[0] * texels[0] + weights[1] * texels[1] +
		weights[2] * texels[2] + weights[3] * texels[3];
}

#undef ABS
