
#ifndef REFLECTION_H
#define REFLECTION_H
#include "lrt.h"
#include "geometry.h"

class BRDF {
  public:

	virtual ~ BRDF();

	virtual Spectrum fr(const Vector & wi) const = 0;

	virtual int SpecularComponents() const;

	virtual Spectrum SampleSpecular(int component, Vector * wo) const;

	virtual Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const =
		0;

	virtual Float Pdf(const Vector & wi) const = 0;

	virtual bool isShader() const { return false; }

};

class Lambertian:public BRDF { public:
	 Lambertian(const Spectrum & reflectance, const Normal & normal) {
		R = reflectance;
		N = normal;
	} Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;
	bool isShader() const { return false; }

  private:

	Spectrum R;
	Normal N;

};

class BlinnGlossy:public BRDF { public:
	 BlinnGlossy(const Spectrum & reflectance, Float roughness,
				 const Normal & normal, const Vector & wo);

	Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;
	bool isShader() const { return false;}

  private:
	 Spectrum R;
	Float invRoughness;
	Vector wo;
	Normal N;
	Float costhetao;

};

class SpecularReflection:public BRDF { public:
	 SpecularReflection(const Spectrum & r,
						const Normal & N, const Vector & wi);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} int SpecularComponents() const {
		return 1;
	} Spectrum SampleSpecular(int component, Vector * wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} 
	bool isShader() const { return false; }
	Float Pdf(const Vector & wi) const {
		return 0.;
  } private:

	 Spectrum R;
	Vector reflectedDirection;

};

class SpecularTransmission:public BRDF {
  public:

	SpecularTransmission(const Spectrum & r,
						 const Normal & N,
						 const Vector & wo, Float indexi, Float indext);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} int SpecularComponents() const {
		return 1;
	} Spectrum SampleSpecular(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } 
	bool isShader() const { return false; }
 private:

	 Spectrum R;
	Vector DirT;

};

class ScatteringMixture:public BRDF {
  public:

	ScatteringMixture():numSpecular(0) {
	} void AddFunction(BRDF * func, Float weight = 1.0) {
		funcs.push_back(func);
		weights.push_back(weight);
		numSpecular += func->SpecularComponents();
	} ~ScatteringMixture();

	int SpecularComponents() const {
		return numSpecular;
	} Spectrum fr(const Vector & wi) const;

	Spectrum SampleSpecular(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

	bool isShader() const { return false; }

  private:

	vector < BRDF * >funcs;
	vector < Float > weights;
	int numSpecular;

};

#if 0
class Lafortune:public BRDF { public:
	 Lafortune(int nLobes, const LafortuneLobe lobes[], const Vector & wi,
			   const Normal & N, const Vector & dPdu);

	~Lafortune() {
		delete[]lobes;
	} Spectrum fr(const Vector &) const;

  private:

	int nLobes;
	LafortuneLobe *lobes;
	Normal N;
	Vector wo;
	Vector dPdu, dPdv;

};
#endif

class SLMachine: public BRDF{ public:
     SLMachine(const vector <union _operation> *_code, const ShadeContext  & sc);
     ~SLMachine() { }

     Spectrum fr(const Vector &wi) const;
     Spectrum fr(const Vector &wi, const Spectrum* lightdE ) const;

     Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const { RI_UNIMP(); return Spectrum(0.); }
     Float Pdf( const Vector &wi) const { RI_UNIMP(); return 0; }

     bool isShader() const { return true; }

 private:
     void PerformFloor(const unsigned char dst, const unsigned char src) const;
     void PerformCeil(const unsigned char dst, const unsigned char src) const;
     void PerformDiv(const unsigned char dst, const unsigned char src0,
		     const unsigned char src1) const;
     void PerformBLT(const unsigned char a, const unsigned char b, const
		     short rel) const;
     void PerformLC(const unsigned char dst, const unsigned char index,
		    const unsigned char src) const;
     void PerformMOVC(const unsigned char dst, const unsigned char index,
		      const unsigned char src) const;
     void PerformLookup(const unsigned char dst, const unsigned char
			texture, const unsigned char tc) const;
     void PerformEXP(const unsigned char dst, const unsigned char
		     exponent) const;
     void PerformRnd(const unsigned char dst) const;
     void PerformClamp(const unsigned char dst, const unsigned char src0,
		       const unsigned char src1) const;
     void PerformTurb(const unsigned char dst, const unsigned char src0) const;
     void PerformTrace(const unsigned char dst, const unsigned char src0,
		       const unsigned char src1) const;
     void PerformNorm(const unsigned char dst, const unsigned char src) const;
     void PerformAdd(const unsigned char dst, const unsigned char src0,
		     const unsigned char src1) const;
     void PerformSub(const unsigned char dst, const unsigned char src0,
		     const unsigned char src1) const;
     void PerformLI(const unsigned char dst, const float val) const;
     void PerformLIV(const unsigned char dst, const unsigned char index, const float val) const;
     void PerformPow(const unsigned char dst, const unsigned char src,
		     const unsigned char exp) const;
     void PerformMul(const unsigned char dst, const unsigned char src0,
		     const unsigned char src1) const;
     void PerformDP3(const unsigned char dst, const unsigned char src0,
		     const unsigned char src1) const;
     void PerformMov(const unsigned char dst, const unsigned char src) const;
     Float* GetSrcReg(const unsigned char src) const;
     Float* GetDstReg(const unsigned char dst) const;

     Transform* worldToObject;
     
     mutable ShadeContext* savesc;
     
     
     mutable TextureMap* Tex0;
     mutable TextureMap* Tex1;
     mutable TextureMap* Tex2;
     mutable TextureMap* Tex3;
     mutable TextureMap* Tex4;
     mutable TextureMap* Tex5;
     mutable TextureMap* Tex6;
     mutable TextureMap* Tex7;

     vector <union _operation> *_codeBase;
     //  vector machine registers
     mutable Float C0[4];  // diffuse color
     mutable Float C1[4];  // specular color
     mutable Float L[4];   // light position
     mutable Float V[4];   // viewer position
     mutable Float xy[4];  // point
     mutable Float dPdS[4];//
     mutable Float dPdT[4];//
     mutable Float dPdU[4];//
     mutable Float dPdV[4];//
     mutable Float uv[4];  // surface parameterization
     mutable Float N[4];   // surface Normal
     mutable Float t0[4];  // texels
     mutable Float t1[4];
     mutable Float t2[4];
     mutable Float t3[4];
     mutable Float t4[4];
     mutable Float t5[4];
     mutable Float t6[4];
     mutable Float t7[4];
     mutable Float r0[4];  // temporary registers
     mutable Float r1[4];
     mutable Float r2[4];
     mutable Float r3[4];
     mutable Float v0[4];  // return register
     mutable Float P[4];
     mutable Float dE[4];
     mutable Float Ka;
     mutable Float Kt;
     mutable Float Kr;

     // scalar machine registers
     mutable Float v1;
     mutable Float S;     // rougness
     mutable Float Kd;
     mutable Float Ks;
     mutable Float s0;    // temporary registers
     mutable Float s1;
     mutable Float s2;
     mutable Float s3;
     mutable Float I;

     //  special machine registers
     mutable int ip;     
};

#endif // REFLECTION_H
