
#ifndef PRIMITIVES_H
#define PRIMITIVES_H
#include "lrt.h"
#include "geometry.h"
#include "transform.h"
#include "color.h"
#include "shading.h"

class Primitive {
  public:

	Primitive(PrimitiveAttributes * a, SurfaceFunction * sf)
	:attributes(a), surfaceFunction(sf) {
	} virtual BBox BoundObjectSpace() const = 0;

	virtual BBox BoundWorldSpace() const;

	virtual bool CanIntersect() const {
		return true;
	} virtual void Refine(vector < Primitive * >*refined) const;

	virtual bool IntersectClosest(const Ray & ray, Float mint,
								  Float * maxt, HitInfo * hit) const;

	virtual bool IntersectAll(const Ray & ray, Float mint, Float
							  maxt, list < HitInfo * >&hits) const;

	virtual Float Sample(Float u[2], HitInfo * hitinfo) const;

	virtual Float Pdf(const Ray & ray,
					  Float * costhetao, Point * Plight) const;

	virtual ~ Primitive();

	PrimitiveAttributes *attributes;
	SurfaceFunction *surfaceFunction;

};

class HitInfo { public:
	 HitInfo();
	~HitInfo();

	void RecordHit(const Point & Po, const Normal & No, Float uu, Float vv,
				   const Primitive * prim);

	void SetInterpolatedData(InterpolatedPrimData * id);

	const Point *GetPoint(RtToken token) const;

	const Float *GetFloat(RtToken token) const;
	const Vector *GetVector(RtToken token) const;
	const Normal *GetNormal(RtToken token) const;
	const Spectrum *GetColor(RtToken token) const;
	const char *GetString(RtToken token) const;

	Point Pobj;
	Normal NgObj;
	Float u, v;
	Vector dPdU, dPdV, dPdS, dPdT;

	const Primitive *hitPrim;

	InterpolatedPrimData *interpolatedData;

};

class PrimitiveAttributes:public ReferenceCounted { public:
	 PrimitiveAttributes() {

		Orientation = PrimitiveAttributes::LH;

		Sides = 2;

		Color = Opacity = Spectrum(1.0);

		Surface = NULL;

		Sampling = SampleCombination;

		LightShader = NULL;

	} Transform ObjectToWorld, WorldToObject;

	enum { LH, RH } Orientation;

	int Sides;

	list < Light * >Lights;

	Spectrum Color, Opacity;

	Material *Surface;

	enum { SampleSurface, SampleLight, SampleCombination } Sampling;

	AreaLight *LightShader;

};

#if 0
class CSGUnion:public Primitive {
  public:

  private:

	vector < Primitive * >primitives;


};
#endif

#if 0
class CSGIntersection:public Primitive {
  public:

  private:

	vector < Primitive * >primitives;


};
#endif

#if 0
class CSGDifference:public Primitive {
  public:

  private:

	vector < Primitive * >primitives;


};
#endif

#endif // PRIMITIVES_H
