#ifndef __SL_H
#define __SL_H

union _operation
{
     struct _x 
     {
	  unsigned char opcode;
	  unsigned char r_dst;
	  unsigned char r_src0;
	  unsigned char r_src1;

     } op_3;

     struct _y
     {
	  unsigned char opcode;
	  unsigned char r_dst;
	  unsigned char reserved;
	  float         f;
     } op_li_float;

     struct _z
     {
	  unsigned char opcode;
	  unsigned char r_dst;
	  unsigned char reserved;
	  unsigned char r_src;
     } op_copy_scalar;

     struct _w
     {
	  unsigned char opcode;
	  unsigned char reg_val0;
	  unsigned char reg_val1;
	  short         jumprel;
     } op_branch;

     unsigned long chunk[2];

};

enum { rC0, rC1, rL, rV, rP, rXY, rDPDS, rDPDT, rDPDU, rDPDV, rUV, rN,
       rDE, rT0, rT1, rT2, rT3, rT4, rT5, rT6, rT7, rR0, rR1, rR2, rR3, rV0,
       rS0, rS1, rS2, rS3, rV1, rKD, rKS, rS, rKR, rKT, rKA, rINDEX,
       INVALID_REGISTER, NUM_REGISTERS = INVALID_REGISTER };

enum { NOP, MOV, ADD, MUL, DP3, POW, SUB, RND, TURB,
       LI, RET, CLAMP, LIV, NORM, TRACE, BLT,
       JMP, LOOKUP, MOVC, EXP, LC, DIV, FLOOR, CEIL, INVALID_OPERATION, NUM_OPS = INVALID_OPERATION};

extern union _operation operation;

bool SLcompile (const char* on, const char* in);
bool SLdecompile (const char* in);

#endif
