
#include "texture.h"
#include "color.h"

TextureMap::TextureMap(const char *filename)
{
  if( filename )
    Texture = TIFFRead(filename, &width, &height);
}

TextureMap::TextureMap( int w, int h, Spectrum &color ){
  Texture = (Spectrum*) malloc( w * h * sizeof(Spectrum) );
  width = w;
  height = h;
  for( int x = 0; x < width; x++ )
    for( int y = 0; y < width; y++ )
      Set( x, y, color );
}


void  TextureMap::Set( int x, int y, Spectrum& color ){
  
  if(  x < 0 || y < 0 )
    return;
  if( x >= width || y >= height )
    return;
  
  // flip to make 0,0 at bottom left
  y = height-1-y;
  
  memcpy( &(Texture[ y * width + x]), &color, sizeof(Spectrum) );
}

void TextureMap::ToRasterCoords( int x, int y, float *outU, float *outV ){
  *outU = (float)x/(width-1);
  *outV = (float)y/(height-1);
}


void TextureMap::ToScreenCoords( float u, float v, int *outX, int *outY ){
  
  Float xReal = u * (width - 1);
  Float yReal = v * (height - 1);
  *outX = int (xReal);
  *outY = int (yReal);
  
  
  //float fx = x*width;
  //float fy = y*height;
  
  //*outX = Round(fx);
  //*outY = Round(fy);
  
}

TextureMap::~TextureMap()
{
	delete[]Texture;
}


Spectrum TextureMap::Lookup(Float u, Float v, bool wrap ) const
{
	Float weights[4];
	if (!Texture)
		return Spectrum(1);

	if( wrap ){
	  u = fmod(u, 1.0 );
	  v = fmod(v, 1.0 );

	  if( u < 0.0 ) u = 1.0 + u;
	  if( v < 0.0 ) v = 1.0 + v;
	}
	
	u = Clamp(u, 0., 1.);
	v = Clamp(v, 0., 1.);

	// flip to make 0,0 bottom left
	v = 1-v;

	Float xReal = u * (width - 1);
	Float yReal = v * (height - 1);
	int x = int (xReal);
	int y = int (yReal);

	Float dx = xReal - x;
	Float dy = yReal - y;
	weights[0] = (1. - dx) * (1. - dy);
	weights[1] = (1. - dx) * dy;
	weights[2] = dx * (1. - dy);
	weights[3] = dx * dy;

	Spectrum texels[4];
	texels[0] = Texture[y * width + x];
	if (y < height - 1 && x < width - 1) {
		texels[1] = Texture[(y + 1) * width + x];
		texels[2] = Texture[y * width + x + 1];
		texels[3] = Texture[(y + 1) * width + x + 1];
	} else if (y < height - 1) {
		texels[1] = Texture[(y + 1) * width + x];
		texels[2] = texels[3] = Spectrum(0);
	} else if (x < width - 1) {
		texels[2] = Texture[y * width + x + 1];
		texels[1] = texels[3] = Spectrum(0);
	} else {
		texels[1] = texels[2] = texels[3] = Spectrum(0);
	}

	return weights[0] * texels[0] + weights[1] * texels[1] +
		weights[2] * texels[2] + weights[3] * texels[3];
}
