#include "outline.h"
#include "lrt.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "site.h"

float hornbez( int degree, float coeff[] , float t );
bool SegmentIntersect (Point ip, Point p1, Point p2);

Outline::Outline() {
  
  numSites = 0;
  size = SITE_BLOCK;
  sites = new (Site*)[size];
  

}


Outline::Outline(const Outline & src) {

  int bodyEdgeSites[src.numEdgeSites];
  int regionSites[src.numRegions + 1];

  int i;
  numSites = src.numSites;
  numRegions = src.numRegions;
  numEdgeSites = src.numEdgeSites;
  size = src.size;
  numCurves = src.numCurves;
  numControlPoints = src.numControlPoints;
  numPolySegments = src.numPolySegments;
  polarO = Point(src.polarO);
  numTweakableSites = src.numTweakableSites;
  pivot = Point(src.pivot);
  numBodyEdgeVeins = src.numBodyEdgeVeins;
  numOuterEdgeVeins = src.numOuterEdgeVeins;
  regEP = new Point[numBodyEdgeVeins]; 
  regOEP = new Point[numOuterEdgeVeins];
  for(i=0; i<numEdgeSites; i++) {
    bodyEdgeSites[i] = src.edgeS[i]->index;
  }
  for(i=0; i<=numRegions; i++) {
    regionSites[i] = src.regionS[i]->index;
  }
  
  /*bodyEdgeVeins = new (Vein*)[numBodyEdgeVeins];
  for(i=0; i<numBodyEdgeVeins; i++)
    bodyEdgeVeins[i] = new Vein(src.bodyEdgeVeins[i]);
  outerEdgeVeins = new (Vein*)[numOuterEdgeVeins];
  for(i=0; i<numOuterEdgeVeins; i++)
  outerEdgeVeins[i] = new Vein(src.outerEdgeVeins[i]);*/
 
  sites = new (Site*)[size];
  for(i=0; i<numSites; i++)
    sites[i] = new Site(Point((src.sites[i])->p),i);
  edgeS = new (Site*)[numEdgeSites];
 
  for(i=0; i<numEdgeSites; i++)
    edgeS[i] = sites[bodyEdgeSites[i]];
 
  regionS = new (Site*)[numRegions+1];

 for(i=0; i<=numRegions; i++){
   
     regionS[i] = sites[regionSites[i]];
  
 }
 
}


Outline::Outline(Point **pl, int *rp, int *wp, int numS, int numR,
		 int numES, Point polarOrigin, Point piv, int numBEV, 
		 int numOEV) {

  
  int i;
  numSites = numS;
  numRegions = numR;
  numEdgeSites = numES;
  polarO = polarOrigin;
  pivot = piv;
  numBodyEdgeVeins = numBEV;
  numOuterEdgeVeins = numOEV;
  size = (numS/SITE_BLOCK + 1) *SITE_BLOCK;
  sites = new (Site*)[size];
  regionS = new (Site*)[numR+1];
  regEP = new Point[numBodyEdgeVeins]; 
  regOEP = new Point[numOuterEdgeVeins];
  edgeS = new (Site*)[numES];
  
  for(i=0; i<numS; i++) {
    sites[i]=new Site(Point(*(pl[i])), i);
  }
  for(i=0; i<numR+1; i++) {
    regionS[i] = sites[rp[i]];
    
  }
  for(i=0; i<numES; i++) {
    edgeS[i] = sites[wp[i]];
   
  }

  InitSites();
  CalcPolarCoords();
  CreateControlPoints();
  CreatePolyOutline();
  SetupRegions();
  SetupVeins();
  fprintf(stderr, "Out of Outline constructor.\n");
}




Outline::Outline(Site **sl, Site **rs, Site **es, int numS, int numR, 
		 int numES, Point polarOrigin, Point piv, int numBEV, 
		 int numOEV) {
  int i;
  numSites = numS;
  numRegions = numR;
  numEdgeSites = numES;
  polarO = polarOrigin;
  pivot = piv;
  numBodyEdgeVeins = numBEV;
  numOuterEdgeVeins = numOEV;
  size = (numS/SITE_BLOCK + 1) * SITE_BLOCK;
  sites = new (Site*)[size];
  regionS = new (Site*)[numR+1];
  regEP = new Point[numBodyEdgeVeins]; 
  regOEP = new Point[numOuterEdgeVeins];
  edgeS = new (Site*)[numES];
  for(i=0; i<numS; i++) {
    sites[i] = sl[i];
  }
  for(i=0; i<numR+1; i++) {
    regionS[i] = rs[i];
  }
  for(i=0; i<numES; i++) {
    edgeS[i] = es[i];
  }
  InitSites();
  CalcPolarCoords();
  CreateControlPoints();
  CreatePolyOutline();
  SetupRegions();
  SetupVeins();
}


Outline::~Outline(){
  /*  if(sites)
    delete(sites);
  if(controlP)
    delete(controlP);
  if(polyO)
  delete(polyO);*/
}


void Outline::InitSites() {
  
  for(int i=0; i<numSites; i++) {  
    InitSite(i);  
  }
}


Point * Outline::CreateControlPoints() {
   
  Point *cp;
  numCurves = numSites;
  numControlPoints = numCurves*3;
  //  printf( "num ctl points: %d\n", numControlPoints );
  cp = new Point[numControlPoints+1];
  //printf( "here5\n" );
  for(int i=0; i<numSites; i++) {
    cp[i*3] = sites[i]->p;
    cp[i*3+1] = sites[i]->p + (sites[i]->mag2)*(sites[i]->d);
    cp[i*3+2] = sites[i]->next->p - 
      (sites[i]->next->mag1)*(sites[i]->next->d);

  }
  
  cp[numControlPoints] = cp[0];
  
  
  controlP = cp;
  return cp;
  
}

void Outline::RandomSubdivide(int index, int totalsubdiv, int max, float threshold) {

  
  if(totalsubdiv==max || index<0 || index>numSites-1)
    return;
  float randMult = 1.0/(float)RAND_MAX;
  

  //float subdivThreshold = .8;
  if(randMult * (float) rand() < threshold) return;
  
  

  float randV = randMult * (float) rand();
  Point newP = GetCurvePoint(index, randV);
  float dx = sites[index]->p.x - sites[index+1]->p.x;
  float dy = sites[index]->p.y - sites[index+1]->p.y;
  //float length = curveLen[index];
  /*float p1x = sites[index]->p.x;
  float p2x = sites[index+1]->p.x;
  float p1y = sites[index]->p.y;
  float p2y = sites[index]->p.y;*/
  float length = sqrt(dx*dx + dy*dy);
  
  Vector disp = 1.0/length * Vector(-dy,dx,0.);
  
  
  float dispConst = .03;
  float dispMult = dispConst * randMult * rand();
  //float xOffset = .01 * randMult * rand() * (-dy/dx);
  //float yOffset = .01 * randMult * rand() * dx/dy;
  //yOffset = -dy/dx*xOffset;
  //newP.x += xOffset;// - .025;
  //newP.y += yOffset;// - .025;
  newP = newP+(dispMult-dispConst*.5) * disp;
  InsertSite(new Site(Point(newP),index+1), index+1);
  InitSites();
  CalcPolarCoords();
  CreateControlPoints();
  //CreatePolyOutline();
   //SetupRegions();
   //SetupVeins();
  //RandomSubdivide(index+3,totalsubdiv+1,max);
  RandomSubdivide(index+2,totalsubdiv+1,max, threshold);
  RandomSubdivide(index-2,totalsubdiv+1, max, threshold);

}


void Outline::RandomCompress(float compressionFactor) {
  
  int i;
  
  //float thetaSpan = tweak[numTweakableSites-1]->theta -  tweak[0]->theta;
  
  for(int i=0; i<numTweakableSites; i++) {
    
    tweak[i]->theta *= compressionFactor / (float) RAND_MAX * rand();
  }
  
  
  for(i=0; i<numTweakableSites; i++) {
    
    tweak[i]->p = 
      Point(polarO.x + tweak[i]->r*cos(tweak[i]->theta), 
	    polarO.y - tweak[i]->r*sin(tweak[i]->theta),
	    tweak[i]->p.z);
  
  }
  
  
  InitSites();
  CalcPolarCoords();
  CreateControlPoints();
  CreatePolyOutline();
  
}


void Outline::InsertSite(Site *site, int index) {
  
  if (numSites+1==size) {
    size += 1000*SITE_BLOCK;
    sites = (Site**) realloc(sites,size);
  }
  if(index<0 || index>numSites) {
    printf("Error! Trying to insert site at invalid index.\n");
    exit(0);
  }

  
  if(index==numSites) {
    sites[index] = site;
  }
  else {
    memmove(&(sites[index+1]),&(sites[index]),(numSites-index)*sizeof(Site*));
    sites[index] = site;
  }  
  
  sites[index]->prev = sites[index-1];
  sites[index-1]->next = sites[index];
  sites[index]->next = sites[index+1];
  sites[index+1]->prev = sites[index];
  
  //InitSite(index-1);
  //InitSite(index);
  //InitSite(index+1);
  ++numSites;
  for(int i=0; i<numSites; i++) 
    sites[i]->index=i;
}



void Outline::CalcPolarCoords() {
  
  int i;
  
  numTweakableSites = regionS[numRegions]->index - regionS[0]->index + 1;
  tweak = new (Site*)[numTweakableSites];
  int index = regionS[0]->index;
  for(i=0; i<numTweakableSites; i++) {
    tweak[i] = sites[index+i];
  }
  
  for(i = 0; i<numTweakableSites; i++) {
    Vector sv = tweak[i]->p - polarO;
    Vector svhat = sv;
    svhat.Normalize();
    tweak[i]->theta = acos(Dot(svhat,Vector(1.,0.,0.)));
    tweak[i]->r = sqrt(sv.x * sv.x + sv.y * sv.y + sv.z * sv.z);
  }
  
}

void Outline::RandPolarTweak(int index, float ThetaRangeMult, 
			     float RadialRange) {

  if(index < 0 || index>=numTweakableSites) {
    fprintf(stderr, "trying to tweak a non-tweakable site!\n");
    return;
  }


  float thetaRange, thetaMin;
  if(index == 0){
    thetaRange = ThetaRangeMult * (tweak[0]->theta - tweak[1]->theta);
    thetaMin = tweak[0]->theta - .5*thetaRange;
    
  }
  else
    if(index == numTweakableSites-1) {
    
      thetaRange = (tweak[numTweakableSites - 2]->theta - 
		    tweak[numTweakableSites - 1]->theta) * ThetaRangeMult;
      thetaMin = tweak[numTweakableSites - 1]->theta - .5*thetaRange;
    }
    else {
      
      thetaRange = .5 * ThetaRangeMult * 
	(tweak[index-1]->theta - tweak[index+1]->theta);
      thetaMin = tweak[index]->theta - .5*ThetaRangeMult*
	(tweak[index]->theta - tweak[index+1]->theta);
    }


  float theta = rand() / (float) RAND_MAX * thetaRange;
  float r = rand() / (float) RAND_MAX * RadialRange;
  
  tweak[index]->theta = thetaMin + theta;
  tweak[index]->r += r - RadialRange * .5;
  
  tweak[index]->p = 
    Point(polarO.x + tweak[index]->r*cos(tweak[index]->theta), 
	  polarO.y - tweak[index]->r*sin(tweak[index]->theta),
	  tweak[index]->p.z);

  if(index!=0)
    InitSite(tweak[index-1]->index);
  InitSite(tweak[index]->index + 1);
  if(index!=numTweakableSites-1)
     InitSite(tweak[index+1]->index);

  CalcPolarCoords();
  CreateControlPoints();
  CreatePolyOutline();
  //SetupRegions();
  
  
  
}


Point * Outline::CreatePolyOutline() {

  int i,j;
  numPolySegments = numCurves * CURVE_SEGMENT;
  Point *po = new Point[numPolySegments + 1];
  Float *sl = new float[numPolySegments];
  Float *cl = new float[numCurves];
  float delta = 1./CURVE_SEGMENT;

  for(i=0; i<numCurves; i++) {   
    
    for(j=0; j<CURVE_SEGMENT; j++) {
     
      po[i * CURVE_SEGMENT + j] = GetCurvePoint( i, delta * (float) j );
     
     
	      
    }
  }
  
  
  
  
  float x,y,z;
  for(i=0; i<numPolySegments; i++) {
    x = po[i+1].x - po[i].x;
    y = po[i+1].y - po[i].y;
    z = po[i+1].z - po[i].z;
    sl[i] = sqrt( x*x + y*y + z*z );
  }
  
  float len;
  for(i=0; i<numCurves; i++) {
    len = 0.;
    for(j=0; j<CURVE_SEGMENT; j++) {
      len += sl[ i * CURVE_SEGMENT + j ];
    }
    cl[i] = len;
    
  }

  
  po[numPolySegments] = po[0];
  
  
  
  polyO = po;
  segLen = sl;
  curveLen = cl;

  return po;
}



Point Outline::GetCurvePoint( int curve_index, float t){
  Point p;
  Point *cp = controlP;
  
  //int i = 2 * curve_index;    //calc control point index
  int i = 3 * curve_index; 
  
  float coeffx[4] = { cp[i].x, cp[i+1].x, cp[i+2].x, cp[i+3].x};
  float coeffy[4] = { cp[i].y, cp[i+1].y, cp[i+2].y, cp[i+3].y};
  float coeffz[4] = { cp[i].z, cp[i+1].z, cp[i+2].z, cp[i+3].z};
  

  /*float coeffx[3] = { cp[i].x, cp[i+1].x, cp[i+2].x };
  float coeffy[3] = { cp[i].y, cp[i+1].y, cp[i+2].y };
  float coeffz[3] = { cp[i].z, cp[i+1].z, cp[i+2].z };*/
  

  /*float coeffx[3] = { cpList[i][0][0], cpList[i][1][0], cpList[i][2][0]  };
  float coeffy[3] = { cpList[i][0][1], cpList[i][1][1], cpList[i][2][1]  };
  float coeffz[3] = { cpList[i][0][2], cpList[i][1][2], cpList[i][2][2]  };*/

  p.x = hornbez( 3, coeffx, t );
  p.y = hornbez( 3, coeffy, t );
  p.z = hornbez( 3, coeffz, t );

  return p;
}





/* Need to make this function smarter. */
bool Outline::IntersectOutline( Point IntersectionP) const {
  
  //if ( !polyO ) CreatePolyOutline();

  int numIntersections = 0;
 
  
  for (int i=0; i<numPolySegments; i++) {
    
    if( SegmentIntersect(IntersectionP, polyO[i], polyO[i+1]) )
      ++numIntersections;
  }

  if ( numIntersections % 2 == 0 ) return false;
  else return true;

}


Site * Outline::GetS(int index) {
  
  if(index<0 || index>=numSites) {
    printf("Error! Trying to return site with invalid index.\n");
    exit(1);
  }

  return sites[index];
}


void Outline::InitSite(int index){
  
  Point p1,p2,pI;
  Vector p1pI, pIp2,dir;
  float len1,len2;
  
  if(index<0 || index>=numSites) {
    printf("Error! Trying to init site with invalid index.\n");
    exit(1);
  }
 
  
  //connect linked list pointers
  
   if(index==0) {
     sites[index]->next = sites[1];
     sites[index]->prev = sites[numSites-1];
   }
   else 
     if(index==numSites-1) {
       sites[index]->next = sites[0];
       sites[index]->prev = sites[index-1];
     }
     else {
       sites[index]->next = sites[index+1];
       sites[index]->prev = sites[index-1];
     }
   /*
       
  switch(index){
   
    case 0: 
      sites[index]->next = sites[1];
      sites[index]->prev = sites[numSites-1];
      break;
    case max:
      sites[index]->next = sites[0];
      sites[index]->prev = sites[index-1];
      break;
    default:
      sites[index]->next = sites[index+1];
      sites[index]->prev = sites[index-1];
    }
   */

  
  //find the correct vector for the direction at this site, based on the
  //distance and direction to the previous and next sites in the list/loop
  
  p1 = sites[index]->prev->p; 
  p2 = sites[index]->next->p;
  pI = sites[index]->p;

  p1pI = Vector(pI - p1);
  pIp2 = Vector(p2 - pI);

  len1 = sqrt(p1pI.x*p1pI.x + p1pI.y*p1pI.y + p1pI.z*p1pI.z);
  len2 = sqrt(pIp2.x*pIp2.x + pIp2.y*pIp2.y + pIp2.z*pIp2.z);
  
  p1pI.Normalize();
  pIp2.Normalize();
  dir = len2*p1pI + len1*p1pI;
  dir.Normalize();  
  sites[index]->d = dir;
  
  //calculate correct magnitudes for the control points
  
  sites[index]->mag1 = len1*MAG_CONST;
  sites[index]->mag2 = len2*MAG_CONST;
 
}











float hornbez( int degree, float coeff[] , float t ){
	int i;
	int n_choose_i;          /* shouldn't be too large! */
	float fact,t1,aux;

	t1=1.0 - t;  fact=1.0;
	n_choose_i=1;

	aux=coeff[0]*t1;          /* starting the evaluation
                                  loop */
	for(i=1; i<degree; i++)
	{
		fact=fact*t;
		n_choose_i=n_choose_i*(degree-i+1)/i;  /* always int! */
		aux=(aux + fact*n_choose_i*coeff[i])*t1;
	}
	aux = aux + fact*t*coeff[degree];

	return aux;
}






/***Currently Assumes Two Dimensions, Assumes Points In Local 0-1 space***/
/*** Could be sped up by calculating the subtraction values and storing.***/


bool SegmentIntersect (Point ip, Point p1, Point p2) {
  
  Point tp = Point(-1.,-1.,0);
  
  float u1, u2;
  
  float divisor = (tp.y - ip.y)*(p2.x - p1.x) - (tp.x - ip.x)*(p2.y - p1.y);
  float inv_divisor = 1./divisor;
  
  u1 = (tp.x - ip.x) * (p1.y - ip.y) - (tp.y - ip.y) * (p1.x - ip.x);
  u2 = (p2.x - p1.x) * (p1.y - ip.y) - (p2.y - p1.y) * (p1.x - ip.x);
  
  u1 *= inv_divisor;
  u2 *= inv_divisor;

  if ( 0 < u1 && u1 <= 1 && 0 < u2 && u2 <= 1 ) 
    return true;
  
  return false;
}


void Outline::SetupRegions() {
  
  float len[numEdgeSites-1];
  float lenstep;
  int i;
  
  float totalLen = 0.;
  for(i=0; i<numEdgeSites-1; i++) {
    cout<<i<<" "<<endl;
    len[i] = curveLen[edgeS[i]->index];
    totalLen+=len[i];
  }
  lenstep = totalLen/(float)(numBodyEdgeVeins-1);
  
  float outerLen = 0.;
  for(i=regionS[0]->index; i<regionS[numRegions]->index; i++) {
    outerLen+=curveLen[i];
  }
  float outerstep = outerLen/(float)(numOuterEdgeVeins-1);
  cout<<"OUTERSTEP: "<<outerstep<<"  NUMVEINS: "<<numOuterEdgeVeins<<endl;
  float outerUStep = 1.0 / (float) (numOuterEdgeVeins-1.);
  cout << "OUTER EDGE LENGTH: " << outerLen << endl;
    //regOEP = new Point[numOuterEdgeVeins];
    //regEP = new Point[numBodyEdgeVeins];
  
  regEP[0] = edgeS[numEdgeSites-1]->p;
  regEP[numBodyEdgeVeins-1] = edgeS[0]->p;
  regOEP[0] = regionS[0]->p;
  regOEP[numOuterEdgeVeins-1] = regionS[numRegions]->p;
  cout << "HERE I AM" << endl;
  i=1;
  float curlen = lenstep;
  int curIndex = numEdgeSites-2;
  int curveIndex;
  while(i<numBodyEdgeVeins-1) {
    curveIndex = edgeS[curIndex]->index;
    regEP[i] = GetCurvePoint(curveIndex, 1.0 - curlen/curveLen[curveIndex]);
    if( (curlen += lenstep) > curveLen[curveIndex]) {
      curlen-=curveLen[curveIndex];
      curIndex--;
    }
    i++;
  }
  cout << "HERE I AM ALSO" << endl;
  int numSites = regionS[numRegions]->index - regionS[0]->index + 1;  
  //for(i=1; i<numOuterEdgeVeins-1; i++) {
  //  
  // int index = 
  //  (int) ((float)i * ((float)numSites/(float)numOuterEdgeVeins-1));
  //
  //
  //
  //}
  float totalU = (float)(numSites-1);
  outerUStep = totalU / (float)(numOuterEdgeVeins-1);
  i=1;
  curlen = outerstep;
  float curU = outerUStep;
  //curIndex = 0;
  curveIndex = regionS[0]->index;
  while(i<numOuterEdgeVeins-1) {
    /*if(curU>1.0) {
      curU-=1.0;
      curveIndex++;
    }
    else {
      regOEP[i] = GetCurvePoint(curveIndex,curU);
      curU+=outerUStep;
      i++;
      }*/
    if(curlen > curveLen[curveIndex]) {
      curlen -= curveLen[curveIndex];
      curveIndex++;
      cout<<"CURVEINDEX:  "<<curveIndex<<endl;
    }
    else {
      regOEP[i] = GetCurvePoint(curveIndex, curlen/curveLen[curveIndex]);
      curlen+=outerstep;
      i++;
    }
    
    /*float u = curlen/curveLen[curveIndex];
    if(u<=1.0) {
      regOEP[i] = GetCurvePoint(curveIndex, u);
      cout<<"NEW OUTER EDGE VEIN POINT: "<<regOEP[i]<<" U: "<<u<<endl;
      curlen+=outerstep;
      ++i;
    }
    else {
      curlen-=curveLen[curveIndex];
      curveIndex++;
      }*/
    
  }
  
 cout << "HERE I AM ALSO OUT" << endl;
  
}


Point *Outline::RStoWS(int r, float u, float v) {
  
  if( u<0. || v<0. || v>1. ) {
    fprintf(stderr, "Error!  invalid region space u v \n");
    fprintf(stderr, "u: %f   v: %f\n",u,v);
    exit(1);
  }
  if( r<0 || r>=numOuterEdgeVeins ) {
    fprintf(stderr, "Error!  invalid wing section index \n");
    fprintf(stderr, "index: %i\n",r);
    fprintf(stderr, "numSections: %i\n",numOuterEdgeVeins);
    exit(1);
  }
  
  if( u < outerEdgeVeins[r+1]->minu ) {
    return NULL;
  }
  
  int getVeinIndex = r;
  while(u < outerEdgeVeins[getVeinIndex]->minu) {
    getVeinIndex--;
    if(getVeinIndex<0) {
      fprintf
	(stderr, "Error! Trying to get point with bad vein index.\n");
      exit(1);
    }
  }     
  
  Point p1,p2,*ws;
  /*
  p1 = regEP[r] + u * Vector(regionS[r]->p - regEP[r]);
  p2 = regEP[r+1] + u * Vector(regionS[r+1]->p - regEP[r+1]);
  ws = p1 + v * Vector(p2 - p1);
  */

  p1 = outerEdgeVeins[getVeinIndex]->GetVeinPoint(u);
  p2 = outerEdgeVeins[r+1]->GetVeinPoint(u);
  ws = new Point(p1 + v * Vector(p2 - p1));
  
  return ws;
  
  
}


void Outline::SetupVeins() {

  cout << "IN SETUP VEINS" << endl;
  int i;
  float totalOuterEdgeLen=0., totalBodyEdgeLen=0.;

  for(i=0; i<numEdgeSites-1; i++) {
    
    totalBodyEdgeLen += curveLen[edgeS[i]->index];
  }

  for(i=regionS[0]->index; i<regionS[numRegions]->index; i++) {
    
    totalOuterEdgeLen += curveLen[i];
  }

  
  outerEdgeVeins = new (Vein*)[numOuterEdgeVeins];
  bodyEdgeVeins = new (Vein*)[numBodyEdgeVeins];
  
  
  float bodyVStep = 1./(float)(numBodyEdgeVeins - 1);
  float outerVStep = 1./(float)(numOuterEdgeVeins - 1);
  float curOuterV = 0.;
  float curBodyV = 0.;
  
  
  int bodyIndex = 0;
  cout<<"GOING INTO VEIN LOOP TO CREATE "<<numOuterEdgeVeins<<"VEINS"<<endl;
  for(i=0; i<numOuterEdgeVeins; i++) {
    if(curOuterV>=curBodyV) {
      
      //outerEdgeVeins[i] = bodyEdgeVeins[bodyIndex] = 
      //new Vein(Point(regEP[bodyIndex]), Point(regionS[i]->p), 0.);
      outerEdgeVeins[i] = bodyEdgeVeins[bodyIndex] = 
      new Vein(Point(regEP[bodyIndex]), Point(regOEP[i]), 0.);
      bodyIndex++;
      curBodyV+=bodyVStep;
      
      curOuterV+=outerVStep;
      cout<<"CURRENT V:  "<<curOuterV<<endl;
    }
    else {
      
      float randU = .7 * rand() / (float) RAND_MAX;
      randU *= sqrt(randU);
      //randU += .15;
      int mergeVeinIndex = i-1;
      while(randU < outerEdgeVeins[mergeVeinIndex]->minu) {
	  mergeVeinIndex--;
	  if(mergeVeinIndex<0) {
	    fprintf
	      (stderr, "Error! Trying to merge with bad vein index.\n");
	    exit(1);
	  }
      }     
      cout << "Merging with vein #" <<mergeVeinIndex<<endl;
      outerEdgeVeins[i] = 
	new Vein( outerEdgeVeins[mergeVeinIndex]->GetVeinPoint(randU), 
	regOEP[i], randU);
      //outerEdgeVeins[i] = 
      //new Vein( outerEdgeVeins[mergeVeinIndex]->GetVeinPoint(randU), 
      //regionS[i]->p, randU );   
      curOuterV+=outerVStep;
    } 
  }
}


Vein::Vein(Point p1, Point p2, float minU) {

  minu = minU;
  numCP = 3;
  if(minu > 0.) 
    cout << "Creating a New Merged Vein!!!!" << endl;
  else
    cout << "Creating a New Vein!!!!" << endl;
  cout << p1 << "   " << p2 << "     minU: "<<minU<<endl;
  cp = new Point[numCP];
  
  cp[0] = p1;
  cp[2] = p2;
  
  float randMult = 1./(float)RAND_MAX;
  
  float randCenterOffset = .70 * (float)rand() *randMult;
  cp[1] = p1 + (.15+randCenterOffset) * Vector(p2-p1);
  
  //Do something with slope here?
  float dy = p2.y - p1.y;
  float dx = p2.x - p1.x;
  
  float randYOffset = .13 * (float) rand() * randMult;
  
  float randXOffset = .13 * (float) rand() * randMult;
  
  if(p1.x > p2.x)
    randXOffset *= -1.;
  
  cp[1].x += randXOffset;
  cp[1].y += randYOffset;
  
  //cout << "Offsets for new vein:  " << randXOffset << "  " << randYOffset;
  //cout << endl;
  
  degree = 2;
  numCurves = 1;
  
}


Point Vein::GetVeinPoint(float u) {
  
  if( u < minu ) {
    fprintf(stderr, "Bad vein u value!  can't get point.\n");
    exit(0);
  }
  if(degree == 1) {
    //float local_u = u - minu;
    float local_u = (u - minu)/(1.-minu);
    return cp[0] + local_u * Vector(cp[2] - cp[0]);
  }
  if(degree == 2) {
    int i=0;
    float coeffx[3] = { cp[i].x, cp[i+1].x, cp[i+2].x};
    float coeffy[3] = { cp[i].y, cp[i+1].y, cp[i+2].y};
    float coeffz[3] = { cp[i].z, cp[i+1].z, cp[i+2].z};
    Point p;
    float local_u = (u-minu)/(1.0-minu);
    p.x = hornbez( 2, coeffx, local_u );
    p.y = hornbez( 2, coeffy, local_u );
    p.z = hornbez( 2, coeffz, local_u );

    return p;
  }
  
}
