#ifndef _BUTTERFLY_H_
#define _BUTTERFLY_H_

#include "primitives.h"
#include "outline.h"
#include "trimesh.h"

typedef enum {lowerLeft, lowerRight, upperLeft, upperRight} wingType;


struct Body {
  float radius;
};

class Wing:public Primitive {
 public:  
  float height;
  float width;
  float angle;
  float roughness;
  wingType wingT;
  Outline *outline;
  Butterfly *b;




  Wing(const Butterfly * bfly, wingType wingT, float h, float w, float an,
       float r, PrimitiveAttributes * a, SurfaceFunction * sf );

  bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
			HitInfo * hit) const;
  BBox BoundObjectSpace() const;
  //BBox BoundWorldSpace() const;
  void GenerateWingGeometry();
  void GenerateWingTransform();
  bool TriIntersect (const Ray & ray, float mint, float maxt, float *hitt,
		   Point vert[3]) const;

  bool SquareIntersect ( const Ray & ray, float mint, float maxt, float
			 *hit_t, Point vert[4] ) const;

};


class Butterfly:public Primitive {
 public:

  Butterfly( Float wHeight, Float wLength, Float angle, Float roughness,
	     PrimitiveAttributes * a, SurfaceFunction * sf);
  
  bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
			HitInfo * hit) const;
  /* bool LowerWingIntersect( const Ray & ray, float mint, float maxt,
      float * hit_t); */

  bool TriIntersect (const Ray & ray, float mint, float maxt, float *hitt, 
		   Point vert[3]) const;

  bool SquareIntersect ( const Ray & ray, float mint, float maxt, float
		       *hit_t, Point vert[4] ) const;
  
  BBox BoundObjectSpace() const;
  void GenerateWingSurfaces(Wing *ll, Wing *lr, Wing *ul, Wing *ur);

    void GenerateColors();



  bool CanIntersect() const {
		return false;
	} 
  void Refine(vector < Primitive * >*refined) const;

  // Color
  Spectrum    wingBaseColor;
  Spectrum    wingColor[3];

  Wing *llWing;
  Wing *lrWing;
  Wing *ulWing;
  Wing *urWing;
  Body *body;
  TriangleMesh *bodygeo;
  int  textureMode;
  Outline upperWingOutline;
  Outline lowerWingOutline;
};


#endif
