#ifndef LRT_H
#define LRT_H
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <list>
using std::list;
#include <vector>
using std::vector;
#ifndef __GNUG__
#include <pair.h>
#endif // !__GNUG__
using std::pair;
#include "ri.h"
#include <algorithm>
using std::min;
using std::max;
using std::swap;
typedef float Float;
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
typedef unsigned long u_long;
typedef enum {
	RMAN_BROKEN_SHADER,
	RMAN_SURFACE_SHADER,
	RMAN_LIGHT_SHADER,
	RMAN_VOLUME_SHADER,
	RMAN_TRANSFORMATION_SHADER,
	RMAN_DISPLACEMENT_SHADER,
	RMAN_IMAGER_SHADER
} RmanShaderType;
class Scene;
extern Scene *scene;
class ReferenceCounted;
class Vector;
class Point;
class Normal;
class Ray;
class BBox;
class Transform;
class Primitive;
class HitInfo;
class PrimitiveAttributes;

class Accelerator;

class GridAccelerator;
class HBVAccelerator;
class HBVNode;
class Scene;
class Camera;
class PinholeCamera;
class Image;
class JitterSampler;
class GeneralSampler;
class Spectrum;
class SurfaceFunction;
class InterpolatedPrimData;

class MaterialAttributes;
class ShadeContext;
class Material;
class MatteSurface;
class PlasticSurface;
class PaintedPlasticSurface;
class CheckeredSurface;
class GlassSurface;
class ShinyMetalSurface;
class ViewSTSurface;
class MIPMap;

class TextureMap;
class BRDF;
class Lambertian;
class BlinnGlossy;
class SpecularReflection;
class SpecularTransmission;
class ScatteringMixture;
class Lafortune;
class LightAttributes;
class Light;
class IsotropicPointLight;
class DirectionalLight;
class SpotLight;
class AmbientLight;
class AreaLight;
class DiffuseAreaLight;
class Integrator;
class ColorIntegrator;
class RayCastingIntegrator;
class WhittedIntegrator;
class MCIntegrator;
class Sampler;
class SLTriple;
class RendermanIntegrator;
#define LRT_VERSION 0.08
#define STATS_NONE 0
#define STATS_BASIC 1
#define STATS_DETAILED 2
#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif
#define INV_255 .00392156862745098039
#define INFINITY HUGE_VAL
#ifdef __GNUG__
#define PRINTF_FORMAT __attribute__ ((__format__ (__printf__, 1, 2)))
#else
#define PRINTF_FORMAT
#endif // __GNUG__
extern void Info(const char *, ...) PRINTF_FORMAT;
extern void Warning(const char *, ...) PRINTF_FORMAT;
extern void Error(const char *, ...) PRINTF_FORMAT;
extern void Severe(const char *, ...) PRINTF_FORMAT;
extern void StatsRegisterCounter(int level, const char *category,
								 const char *name, int *ptr);
extern void StatsRegisterRatio(int level, const char *category,
							   const char *name, int *pa, int *pb);
extern void StatsPrint(int level, FILE * dest);
extern void StatsCleanup();
void MatrixInvert(Float m[4][4], Float minv[4][4]);
extern Float RandomFloat(Float min = 0., Float max = 1.);
Point Lerp(Float t, const Point & p1, const Point & p2);
extern Transform Translate(const Vector & delta);
extern Transform RotateX(Float angle);
extern Transform RotateY(Float angle);
extern Transform RotateZ(Float angle);
extern Transform Rotate(Float angle, const Vector & axis);
extern Transform Scale(Float x, Float y, Float z);
extern Transform Orthographic(Float near, Float far);
extern Transform Frustum(Float left, Float right,
						 Float bottom, Float top, Float near, Float far);
extern Transform Perspective(Float fovy, Float aspect,
							 Float znear, Float zfar);
extern void ApplyImager(const char *name, Float * RGBPixels,
						Float * alphas, Float * depths, int nPixels);
extern Material *MaterialCreate(const char *name,
								SurfaceFunction * bindings);
extern BRDF *CreateLambertian(const Spectrum & reflectance,
							  const Normal & normal);
extern BRDF *CreateBlinnGlossy(const Spectrum & reflectance,
							   Float roughness, const Normal & normal,
							   const Vector & wo);
extern BRDF *CreateSpecularReflection(const Spectrum & r, const Normal & N,
									  const Vector & wo);
extern BRDF *CreateSpecularTransmission(const Spectrum & r,
										const Normal & N,
										const Vector & wo, Float indexi,
										Float indext);
extern ScatteringMixture *CreateScatteringMixture();
extern Light *PointLightCreate(const char *name, SurfaceFunction * data,
							   LightAttributes * attr);
extern AreaLight *AreaLightCreate(const char *name, SurfaceFunction * data,
								  LightAttributes * attr);
extern Spectrum *TIFFRead(const char *name, int *xSize, int *ySize);
extern void TIFFWrite8Bit(const char *name, Float * RGB, Float * alpha,
						  Float * depth, int XRes, int YRes);
extern void TIFFWriteFloat(const char *name, Float * RGB, Float * alpha,
						   Float * depth, int XRes, int YRes);
extern bool ParseRIB(const char *filename);
extern void ParseEnableDebug();
class ReferenceCounted { public:
	void Reference() const {
		++References;
	} void Dereference() const {
		if (--References == 0)
			delete this;
	} int GetReferences() const {
		return References;
  } protected:
	ReferenceCounted()
{
	References = 1;
} ~ReferenceCounted() {
}
friend class ShutupDumbGNUG;
private:
mutable int References;
};
class StringHashTable { public:
	u_int Hash(const char *str) const;
	void *Search(const char *key) const;
	void Add(const char *key, void *data);
  private:
	static const int NUM_BUCKETS = 1047;
	typedef list<pair<const char *, void *> > ItemType;
	ItemType buckets[NUM_BUCKETS];
};
#ifdef NDEBUG
#define Assert(expr) ((void)0)
#else
#define Assert(expr) \
    ((expr) ? (void)0 : Severe("Assertion " #expr " failed in %s, line %d", \
                            __FILE__, __LINE__))
#endif // NDEBUG
inline Float Lerp(Float pos, Float start, Float end)
{
	return (1. - pos) * start + pos * end;
}
inline Float Clamp(Float val, Float low, Float high)
{
	if (val < low)
		return low;
	else if (val > high)
		return high;
	else
		return val;
}
inline int Step(Float stepPos, Float val)
{
	if (val < stepPos)
		return 0;
	else
		return 1;
}
inline Float SmoothStep(Float min, Float max, Float value)
{
	Float v = Clamp((value - min) / (max - min), 0., 1.);
	return -2. * v * v * v + 3. * v * v;
}
inline int Round(Float val)
{
	return (int) rint(val);
}
inline int Mod(int a, int b)
{
	int n = int (a / b);
	a -= n * b;
	if (a < 0)
		a += b;
	return a;
}
inline Float Radians(Float deg)
{
	return (M_PI / 180.) * deg;
}
inline Float Degrees(Float rad)
{
	return (180. / M_PI) * rad;
}
inline char *Strdup(const char *str)
{
	char *ret = new char[strlen(str) + 1];
	strcpy(ret, str);
	return ret;
}

#ifdef __GNUC__
#define RI_UNIMP() { static int first = 1 ; if (first) { first = 0; Warning( "call to unimplemented function %s!", __PRETTY_FUNCTION__ ); } }
#else
#define RI_UNIMP() { static int first = 1 ; if (first) { first = 0; Warning( "call to unimplemented function!"); } }
#endif
#endif // LRT_H
