
#ifndef COLOR_H
#define COLOR_H
#include "lrt.h"
#include <iostream.h>

#define SPEC 80

class Spectrum {
  public:

	Spectrum() {
		s[0] = s[1] = s[2] = 0.;
		for (int i = 0; i < SPEC; i++) {
			waves[i] = 0.0;
		}
		monochromatic = 0;
		wave_bucket = 0;
	} Spectrum(Float i) {
		s[0] = s[1] = s[2] = i;
		for (int i = 0; i < SPEC; i++) {
			waves[i] = 0.0;
		}
		monochromatic = 0;
		wave_bucket = 0;
	}
	Spectrum(Float r, Float g, Float b) {
		s[0] = r;
		s[1] = g;
		s[2] = b;
		for (int i = 0; i < SPEC; i++) {
			waves[i] = 0.0;
		}
		monochromatic = 0;
		wave_bucket = 0;
	}

	Spectrum(Spectrum R, int wavelength);

	friend ostream & operator << (ostream &, const Spectrum &);

	Spectrum & operator += (const Spectrum & s2) {
		s[0] += s2.s[0];
		s[1] += s2.s[1];
		s[2] += s2.s[2];
		return *this;
	}
	Spectrum operator + (const Spectrum & s2) {
		return Spectrum(s[0] + s2.s[0], s[1] + s2.s[1], s[2] + s2.s[2]);
	} Spectrum operator - (const Spectrum & s2) {
		return Spectrum(s[0] - s2.s[0], s[1] - s2.s[1], s[2] - s2.s[2]);
	} Spectrum operator *(const Spectrum & s2) {
		return Spectrum(s[0] * s2.s[0], s[1] * s2.s[1], s[2] * s2.s[2]);
	} Spectrum operator / (const Spectrum & s2) {
		return Spectrum(s[0] / s2.s[0], s[1] / s2.s[1], s[2] / s2.s[2]);
	}
		Spectrum operator *(const Spectrum & sp) const {
			  return Spectrum(s[0] * sp.s[0], s[1] * sp.s[1],
							  s[2] * sp.s[2]);
	} Spectrum & operator *= (const Spectrum & sp) {
		s[0] *= sp.s[0];
		s[1] *= sp.s[1];
		s[2] *= sp.s[2];
		return *this;
	}

	Spectrum operator *(Float a) const {
		return Spectrum(s[0] * a, s[1] * a, s[2] * a);
	} Spectrum & operator *= (Float a) {
		s[0] *= a;
		s[1] *= a;
		s[2] *= a;
		return *this;
	}
	friend inline Spectrum operator *(Float a, const Spectrum & s) {
		return Spectrum(s.s[0] * a, s.s[1] * a, s.s[2] * a);
	} Spectrum operator / (Float a) const { Float inv = 1. / a;
		 return Spectrum(s[0] * inv, s[1] * inv, s[2] * inv);
	} Spectrum & operator /= (Float a) {
		Float inv = 1. / a;
		s[0] *= inv;
		s[1] *= inv;
		s[2] *= inv;
		return *this;
	}

	bool operator == (const Spectrum & sp) const {
		return (s[0] == sp.s[0] && s[1] == sp.s[1] && s[2] == sp.s[2]);
	}
		Spectrum Pow(const Spectrum & s2) const {
			  return Spectrum(pow(max((Float) 0., s[0]), s2.s[0]),
							  pow(max((Float) 0., s[1]), s2.s[1]),
							  pow(max((Float) 0., s[2]), s2.s[2]));
	} void ConvertToRGB(Float * result) const;

	int inside_gamut();
	int constrain_rgb();

	void populateWaves();

	void printWaves();
	void printRGB();

	void spectrum_to_rgb() { spectrum_to_xyz(); xyz_to_rgb(); }
	void spectrum_to_xyz();
	void xyz_to_rgb();

	friend class SLTriple;

	/* 0 for no color, 1 for mono, 2 for multi */
	int monochromatic;

	/* If monochromatic ==1, this is the bucket of the wavelength */
	int wave_bucket;

  private:
	Float bb_spectrum(Float wavelength);

	int num_split;
	Float s[3];
	double x;
	double y;
	double z;

	Float waves[SPEC];
};

#endif // COLOR_H
