
#include "lrt.h"
#include "camera.h"
#include "mbdofcamera.h"
#include "image.h"
#include "primitives.h"
#include "scene.h"
#include "transport.h"
#include "accel.h"

Camera::Camera()
{

	ShutterType = LRT_IRIS;
	IrisRate = 20;
	StripeWidth = .25;
	StripeDirection = LRT_LEFT;

	ScreenLeft = -4. / 3.;
	ScreenBottom = -1;
	ScreenRight = 4. / 3.;
	ScreenTop = 1.;

	ClipHither = 1e-2;
	ClipYon = RI_INFINITY;

	ProjectionType = Perspective;

	ShutterStart = 0.;
	ShutterEnd = 1.;

	FStop = RI_INFINITY;
	FocalLength = FocalDistance = RI_INFINITY;

}

void Camera::FinalizeOptions()
{

	invClipHither = 1. / ClipHither;

	CameraToWorld[0] = Transform(WorldToCamera[0].GetInverse());
	CameraToWorld[1] = Transform(WorldToCamera[1].GetInverse());
	ScreenToCamera = Transform(CameraToScreen.GetInverse());

	ScreenToRaster =
		Scale(scene->image->XResolution, scene->image->YResolution, 1.) *
		Scale(1, -1, 1) *
		Scale(1. / (ScreenRight - ScreenLeft),
			  1. / (ScreenTop - ScreenBottom), 1.) *
		Translate(Vector(-ScreenLeft, -ScreenTop, 0.));
	RasterToScreen = Transform(ScreenToRaster.GetInverse());

	WorldToScreen = CameraToScreen * WorldToCamera[0];
	RasterToCamera = ScreenToCamera * RasterToScreen;

}

bool PinholeCamera::GenerateRay(Float sample[5], Ray & ray) const
{

	if (sample[0] < scene->image->SampleCropLeft ||
		sample[0] > scene->image->SampleCropRight ||
		sample[1] < scene->image->SampleCropBottom ||
		sample[1] > scene->image->SampleCropTop) return false;

	Point Pcamera;
	switch (ProjectionType) {
	case Camera::Orthographic:
		Pcamera = RasterToCamera(Point(sample[0], sample[1], 0));
		ray = Ray(Pcamera, Vector(0, 0, 1));
		break;
	case Camera::Perspective:
		Pcamera = RasterToCamera(Point(sample[0], sample[1], 0));
		ray = Ray(Point(0, 0, 0), Vector(Pcamera.x, Pcamera.y, Pcamera.z));
		ray.D *= invClipHither;
		break;
	}
	ray = CameraToWorld[0] (ray);
	return true;

}
