function savewaves(waves, fnwaves)

% savewaves - outputs a wave pattern as a heightfield to a renderman .rib file

dim = size(waves,1);

fid = fopen(fnwaves,'w');

fprintf(fid, 'PatchMesh "bilinear" %d "nonperiodic" %d "nonperiodic" "Pz" [\n',dim,dim);

for q = 1:dim
   for w = 1:dim
      if (w > 1)
         fprintf(fid, ' ');
      end
      
      fprintf(fid, '%f', waves(q,w));
   end
   fprintf(fid, '\n');
end
fprintf(fid, ']\nWorldEnd');

fclose(fid);
   