function noise = noiseptn(dim)

% noiseptn - create a scaling pattern for some random noise
% added to the magnitude of the fft of the wave image

noise = zeros(dim,dim);

cx = dim/2 + 0.5;
cy = cx;

scale = dim/2;
for x = 1:dim
   for y = 1:dim
      
      dx = x - cx;
      dy = y - cy;
      
      theta = atan(dx/dy);
      
      	if ( (y > cx) & (x < cx))
            theta = -theta;
         elseif ( (y < cx) & (x > cx) )
            theta = -theta;
         end
        
         f = sqrt(dx^2 + dy ^2)/scale;
         
         % noise pattern excludes the highest frequencies 
         % and falls off as 1/f^3 at downwind directions -
         % 1 added in denominator to prevent blowup at 0
         % also falls off directionally
         if (f < .95)
            noise(y,x) = cos(theta)/(1+10*f^3);
         end
        
   end
end