function waves = genwaves(D,var)

% genwaves: generates a heightfield of ocean waves using a 2-d frequency
% distribution, and a scaling factor for random hi-freq noise.
%
% D - directional frequency distribution pattern for waves
% var - scale factor for random noise in frequency domain

freqs = D;
dim = size(freqs,1);

% make a white noise image
test1 = unifrnd(-127,127,dim,dim);

%sigp1 = sum(sum(test1.^2))

% take 2-d fourier transform of white noise image
testfft = fft2(test1);

% find magnitude of fourier transform
mag = abs(testfft)/dim;

% find total power in the signal
sigpwr = sum(sum(mag.^2));

% put DC components at the center
testfft = fftshift(testfft);

% find phase of fourier transform
phase = angle(testfft);

% filter magnitude by directional frequency distribution
mag = mag .* freqs;

% normalize filter to have gain of 1 - make sure power stays
% constant in the signal (to avoid a peak at DC level when taking
% inverse fft)
sigpwr2 = sum(sum(mag.^2));
pwrdiff = sigpwr/sigpwr2;
mag = mag * sqrt(pwrdiff);

% add random noise to magnitudes to add some roughness to the waves
noise = normrnd(0,var,dim,dim);
noise = noise*noiseptn(dim);
mag = mag+noise;

% use new magnitudes with original phase angles to get altered freq. domain
% image
im = mag.*sin(phase);
r = mag.*cos(phase);

filtered = r + im*j;
filtered = fftshift(filtered);

% inverse fft to get time-domain 2-d wave pattern
waves = ifft2(filtered);
waves = abs(waves);

% scale down wave heights and flip Z values to match with rendering platform
waves = waves * -0.02;