#include <stdio.h>
#include <math.h>
#include <string.h>

FILE *infile,*outfile;

typedef struct {
	float x,y,z;
} Point;

#define MAXPTS 1000000
#define NVERTS 3
Point pts[MAXPTS];
Point norms[MAXPTS];
float s[MAXPTS], t[MAXPTS];
int   pt_indices[MAXPTS];
int   norm_indices[MAXPTS];
int   tex_indices[MAXPTS];
int   pt_index =0;
int   norm_index =0;
int   tex_index =0;
int   face_index = 0;
int   num_faces = 0;

int readline()
{
	char data_type[3];
	int test=!EOF;
	
	fscanf(infile,"%s",data_type);
	if (data_type[0] == 'v')
	{
	   if (data_type[1] == 't')
	   {
	      fscanf(infile,"%f %f\n",&s[tex_index],&t[tex_index]);
	      if (++tex_index == MAXPTS)
	      {
	   	printf ("Too many points");
	   	return 1;
	      }
	   }
	   else if (data_type[1] == 'n')
	   {
	      fscanf(infile,"%f %f %f\n",&norms[norm_index].x,&norms[norm_index].y,&norms[norm_index].z);
	      if (++norm_index == MAXPTS)
	      {
	   	printf ("Too many points");
	   	return 1;
	      }
	   }
	   else
	   {
	      fscanf(infile,"%f %f %f\n",&pts[pt_index].x,&pts[pt_index].y,&pts[pt_index].z);
	      if (++pt_index == MAXPTS)
	      {
	   	 printf ("Too many points");
	   	 return 1;
	      }
	   }
	}
	else if (data_type[0] == 'f')
	{
	  while (test != EOF)
	  {
	    for (int i=0; i<NVERTS; i++)
	    {
	       test =fscanf(infile,"%d/%d/%d",&pt_indices[face_index],&tex_indices[face_index],&norm_indices[face_index]);
	       face_index++;
	    }
	    if (test != EOF)
	    {
	      	test = fscanf(infile,"%s",data_type);
	      	if (test == EOF || data_type[0] != 'f')
	      	{
	      		num_faces++;
	      		break;
	      	}
	    }
	    num_faces++;
	      	
	  }
	  return 1;
	}
	return 0;
	
}

int main(int argc, char *argv[])
{
	int i,index,done=0;
	char outfilename[255];
		
	if (argc < 3) {
		printf("Usage: parse in_file.obj out_file.rib\n" );


	}
	else
	{
		printf("Opening input obj file %s\n",argv[1]);
		strcpy(outfilename,argv[2]);
		infile = fopen(argv[1], "r");
		
		while (!done)
			done = readline();
		fclose(infile);

		printf("Opening output rib file %s\n",outfilename);
		outfile = fopen(outfilename, "w");
		
		fprintf(outfile,"PointsPolygons [");
		for (i=0; i<num_faces; i++)
		{
			fprintf(outfile," %d",NVERTS);
			if (fmod(i,20)==0)
			   fprintf(outfile,"\n");
		}
		fprintf(outfile,"][");
		for (i=0; i<face_index; i++)
		{
			fprintf(outfile," %d",i);
			if (fmod(i,20)==0)
			   fprintf(outfile,"\n");
		}
		fprintf(outfile,"]");

		//write_points
		fprintf(outfile,"\"P\" [");
		for (i=0; i<face_index; i++)
		{       index = pt_indices[i]-1;
			fprintf(outfile,"%f %f %f ",pts[index].x,pts[index].y,pts[index].z);
			if (fmod(i,2)==0)
			   fprintf(outfile,"\n");
			
		}
		fprintf(outfile,"]\n");

		//write_normals
		fprintf(outfile,"\"N\" [");
		for (i=0; i<face_index; i++)
		{       index = norm_indices[i]-1;
			fprintf(outfile,"%f %f %f ",norms[index].x,norms[index].y,norms[index].z);
			if (fmod(i,2)==0)
			   fprintf(outfile,"\n");
			
		}
		fprintf(outfile,"]\n");
		
		//write_tex coords
		fprintf(outfile,"\"s\" [");
		for (i=0; i<face_index; i++)
		{       index = tex_indices[i]-1;
			fprintf(outfile,"%f ",s[index]);
			if (fmod(i,5)==0)
			   fprintf(outfile,"\n");
			
		}
		fprintf(outfile,"]\n");
		fprintf(outfile,"\"t\" [");
		for (i=0; i<face_index; i++)
		{       index = tex_indices[i]-1;
			fprintf(outfile,"%f ",t[index]);
			if (fmod(i,5)==0)
			   fprintf(outfile,"\n");
			
		}
		fprintf(outfile,"]\n");

	}

	return 0;
}
