
#include "lrt.h"
#include "color.h"
#include "geometry.h"

int main(int argc, char *argv[])
{
	int width, height;
	int outw,outh;
	Float *RGBOut = NULL;
	Float as[3],bs[3],cs[3];
	int jw;
	Point  a, b, c;
	Vector v1,v2, N;
	int k=0;
		
	if (argc < 3) {
		printf("Usage: bump_create heightfile.tiff bumpfile.tiff\n" );


	} else {
		printf("Opening input heightfile %s\n",argv[1]);
		Spectrum *Heights= TIFFRead(argv[1],&width,&height);
		
		outw = width-1;
		outh = height-1;
		RGBOut = new Float[3 * outw * outh];
		for (int j = 0; j < outh; j++){
		   jw = j * width;
		   for (int i = 0; i < outw; i++){
		  	//Compute normal given 3 height values
			Heights[jw+width+i].ConvertToRGB(as);
			Heights[jw+i].ConvertToRGB(bs);
			Heights[jw+i+1].ConvertToRGB(cs);
			//we are assuming r,g,b are equal (greyscale image)
		  	a = Point(i,j+1,as[0]);
		  	b = Point(i,j,bs[0]);
		  	c = Point(i+1,j,cs[0]);
		  	v1 = c - b;
		  	v2 = a - b;
		  	//x's and y's can only be 0's and 1's
		  	N.x = v1.z * v1.x + v2.z * v2.x;
		  	N.y = v1.z * v1.y + v2.z * v2.y;
		  	N.z = v1.z * v1.z + v2.z * v2.z;
		  	
		  	//rescale -1->1 to 0->255
		  	N += Vector(1,1,1);
		  	N *= 127.5;
		  	RGBOut[k++] = N.x;
		  	RGBOut[k++] = N.y;
		  	RGBOut[k++] = N.z;
		  	}
		}
		
		printf("Opening output bumpfile %s\n",argv[2]);
		TIFFWrite8Bit(argv[2],RGBOut,0,0,outw,outh);


	}

	return 0;
}
