
#ifndef REFLECTION_H
#define REFLECTION_H
#include "lrt.h"
#include "geometry.h"
//ours
#include "primitives.h"

class BRDF {
  public:

	virtual ~ BRDF();

	virtual Spectrum fr(const Vector & wi) const = 0;

	virtual int SpecularComponents() const;

	virtual Spectrum SampleSpecular(int component, Vector * wo) const;

	virtual Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const =
		0;

	virtual Float Pdf(const Vector & wi) const = 0;

	//ours
	virtual Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) {return de*fr(wi);}

	//ours-new stuff
	virtual Spectrum ModifyReflectance() { return Spectrum(1.); }

};

class Lambertian:public BRDF { public:
	 Lambertian(const Spectrum & reflectance, const Normal & normal) {
		R = reflectance;
		N = normal;
	} Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

	//ours
	Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const {return de*fr(wi);}
  private:

	//ours-new stuff
	Spectrum ModifyReflectance() { return Spectrum(1.); }

	Spectrum R;
	Normal N;

};

class BlinnGlossy:public BRDF { public:
	 BlinnGlossy(const Spectrum & reflectance, Float roughness,
				 const Normal & normal, const Vector & wo);

	Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

	//ours
	Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const {return de*fr(wi);}

	//ours-new stuff
	Spectrum ModifyReflectance() { return Spectrum(1.); }

  private:
	 Spectrum R;
	Float invRoughness;
	Vector wo;
	Normal N;
	Float costhetao;

};

class SpecularReflection:public BRDF { public:
	 SpecularReflection(const Spectrum & r,
						const Normal & N, const Vector & wi);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} int SpecularComponents() const {
		return 1;
	} Spectrum SampleSpecular(int component, Vector * wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } 

	//ours
	Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const {return de*fr(wi);}
 private:

	//ours-new stuff
	Spectrum ModifyReflectance() { return Spectrum(1.); }

	 Spectrum R;
	Vector reflectedDirection;

};

class SpecularTransmission:public BRDF {
  public:

	SpecularTransmission(const Spectrum & r,
						 const Normal & N,
						 const Vector & wo, Float indexi, Float indext);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} int SpecularComponents() const {
		return 1;
	} Spectrum SampleSpecular(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } 

	//ours
	Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const {return de*fr(wi);}

	//ours-new stuff
	Spectrum ModifyReflectance() { return Spectrum(1.); }

 private:

	 Spectrum R;
	Vector DirT;

};

class ScatteringMixture:public BRDF {
  public:

	ScatteringMixture():numSpecular(0) {
	} void AddFunction(BRDF * func, Float weight = 1.0) {
		funcs.push_back(func);
		weights.push_back(weight);
		numSpecular += func->SpecularComponents();
	} ~ScatteringMixture();

	int SpecularComponents() const {
		return numSpecular;
	} Spectrum fr(const Vector & wi) const;

	Spectrum SampleSpecular(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

	//ours
	Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const {return de*fr(wi);}

	//ours-new stuff
	Spectrum ModifyReflectance() { return Spectrum(1.); }

  private:

	vector < BRDF * >funcs;
	vector < Float > weights;
	int numSpecular;

};

#if 0
class Lafortune:public BRDF { public:
	 Lafortune(int nLobes, const LafortuneLobe lobes[], const Vector & wi,
			   const Normal & N, const Vector & dPdu);

	~Lafortune() {
		delete[]lobes;
	} Spectrum fr(const Vector &) const;

	//ours
	Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const {return de*fr(wi);}

	//ours-new stuff
	Spectrum ModifyReflectance() { return Spectrum(1.); }

  private:

	int nLobes;
	LafortuneLobe *lobes;
	Normal N;
	Vector wo;
	Vector dPdu, dPdv;

};
#endif

class Iridescence:public BRDF { public:
  Iridescence(const Spectrum & reflectance, const Normal & normal, const Float
	      matrix[3][3], const Float cCurves[95][4]) {
    R = reflectance;
    N = normal;
    
    // initialize XYZ to RGB matrix
    for (int i=0; i<3; i++)
      for (int j=0; j<3; j++)
	XYZ2RGBmatrix[i][j] = matrix[i][j];
 
    for (int i=0; i<95; i++)
      for (int j=0; j<4; j++)
	colorCurves[i][j] = cCurves[i][j];


  } Spectrum fr(const Vector & wi) const;
  
  // these are used for sampling the microfacet distribution --
  Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;
  
  Float Pdf(const Vector & wi) const;

  //ours
  Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc,
			  const Vector &wi, HitInfo *hi);

  //ours-new stuff
  Spectrum ModifyReflectance() { return R; }

private:
  Spectrum R;
  Normal N;
  //static const Float colorCurves[95][4];
  Float colorCurves[95][4];
  Float XYZ2RGBmatrix[3][3];

  Spectrum DE;
  Vector wo;
};

class TexturedBRDF:public BRDF { 
 public:
  TexturedBRDF(const Spectrum & sc) {
    surfColor = sc;
  }
  Spectrum fr(const Vector & wi) const;
  
  Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;
  
  Float Pdf(const Vector & wi) const;
 
  Spectrum ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) const;
  
  //ours-new stuff
  Spectrum ModifyReflectance() { return Spectrum(1.); }

 private:

  Spectrum surfColor;


};


#endif // REFLECTION_H
