
#include "lrt.h"
#include "color.h"
#include "reflection.h"

BRDF::~BRDF()
{
}

Spectrum Lambertian::fr(const Vector & wi) const
{
	Float costheta = Dot(wi, N);
	if (costheta > 0.) {
		return R;
	} else {
		return Spectrum(0.);
	}
}

BlinnGlossy::BlinnGlossy(const Spectrum & reflectance,
						 Float roughness, const Normal & normal,
						 const Vector & w)
{
	R = reflectance;
	roughness /= 8.;			// hack to match BMRT, prman
	invRoughness = 1. / roughness;
	N = normal;
	wo = w;
	costhetao = Dot(wo, N);
}

Spectrum BlinnGlossy::fr(const Vector & wi) const
{
	Vector H = (wi + wo).Hat();
	Float costhetah = Dot(N, H);
	Float costhetai = Dot(N, wi);
	if (costhetah > 0. && costhetai > 0.) {
		return R * pow(costhetah, invRoughness) / (costhetai * costhetao);
	} else {
		return Spectrum(0.);
	}
}

int BRDF::SpecularComponents() const
{
	return 0;
}

Spectrum BRDF::SampleSpecular(int component, Vector * wo) const
{
	Severe("SampleSpecular() shouldn't be called for BRDFs "
		   "without specular components.");
	return Spectrum(0.);
}

SpecularReflection::SpecularReflection(const Spectrum & r,
									   const Normal & N, const Vector & wo)
{
	R = r;
	reflectedDirection = -wo - 2. * Dot(N, -wo) * Vector(N);
}

Spectrum SpecularReflection::SampleSpecular(int component, Vector * wi) const
{
	Assert(component == 0);
	*wi = reflectedDirection;
	return R;
}

SpecularTransmission::SpecularTransmission(const Spectrum & r,
										   const Normal & N,
										   const Vector & wo, Float indexi,
										   Float indext)
{
	R = r;

	Float eta = indexi / indext;
	Float c1 = Dot(wo, N);
	Float c2 = 1 - (eta * eta * (1. - c1));
	if (c2 < 0.) {
		// total internal reflection
		R = 0.;
		DirT = wo;
	} else {
		c2 = sqrt(c2);
		DirT = -eta * wo + (eta * c1 - c2) * Vector(N);
	}

}

Spectrum SpecularTransmission::SampleSpecular(int component, Vector * wi) const
{
	Assert(component == 0);
	*wi = DirT;
	return R;
}

ScatteringMixture::~ScatteringMixture()
{
	vector < BRDF * >::const_iterator iter;
	for (iter = funcs.begin(); iter != funcs.end(); ++iter)
		delete *iter;
}

Spectrum ScatteringMixture::fr(const Vector & wi) const
{
	Spectrum ret(0);
	vector < BRDF * >::const_iterator funcIter = funcs.begin();
	vector < Float >::const_iterator weightIter = weights.begin();

	while (funcIter != funcs.end()) {
		ret += (*weightIter) * (*funcIter)->fr(wi);
		funcIter++, weightIter++;
	}
	return ret;
}

Spectrum ScatteringMixture::SampleSpecular(int component, Vector * wi) const
{
	Assert(component < SpecularComponents());
	vector < BRDF * >::const_iterator funcIter = funcs.begin();
	vector < Float >::const_iterator weightIter = weights.begin();

	while (funcIter != funcs.end()) {
		if (component >= (*funcIter)->SpecularComponents())
			component -= (*funcIter)->SpecularComponents();
		else
			return (*weightIter) *
				(*funcIter)->SampleSpecular(component, wi);
		++funcIter, ++weightIter;
	}

	// We shouldn't get to this point.
	Severe("Major logic error in" " ScatteringMixture::SampleSpecular()");
	return Spectrum(0);
}

#if 0
Lafortune::Lafortune(int n, const LafortuneLobe l[], const Vector & w,
					 const Normal & norm, const Vector & dpdu)
{
	nLobes = n;
	lobes = new LafortuneLobe[n];
	for (int i = 0; i < nLobes; ++i)
		lobes[i] = l[i];
	wo = w;
	N = norm.Hat();
	dPdu = dpdu.Hat();
	dPdv = Cross((Vector) N, dPdu);
}
#endif

#if 0
Spectrum Lafortune::fr(const Vector & wi) const
{
	Spectrum value(0.);

	Float xd = Dot(dPdu, wi) * Dot(dPdu, wo);
	Float yd = Dot(dPdv, wi) * Dot(dPdv, wo);
	Float zd = Dot(N, wi) * Dot(N, wo);

	for (int i = 0; i < nLobes; ++i) {

		Spectrum dot =
			xd * lobes[i].Cx + yd * lobes[i].Cy + zd * lobes[i].Cz;
		value += dot.Pow(lobes[i].Exponent);

	}
	return value;
}
#endif

BRDF *CreateLambertian(const Spectrum & reflectance, const Normal & normal)
{
	return new Lambertian(reflectance, normal);
}

BRDF *CreateBlinnGlossy(const Spectrum & reflectance,
						Float roughness,
						const Normal & normal, const Vector & wo)
{
	return new BlinnGlossy(reflectance, roughness, normal, wo);
}

BRDF *CreateSpecularReflection(const Spectrum & r,
							   const Normal & N, const Vector & wo)
{
	return new SpecularReflection(r, N, wo);
}

BRDF *CreateSpecularTransmission(const Spectrum & r,
								 const Normal & N,
								 const Vector & wo,
								 Float indexi, Float indext)
{
	return new SpecularTransmission(r, N, wo, indexi, indext);
}

ScatteringMixture *CreateScatteringMixture()
{
	return new ScatteringMixture;
}

#if 0
BRDF *CreateLafortune(int nLobes, const LafortuneLobe lobes[],
					  const Vector & wi, const Normal & N,
					  const Vector & dPdu)
{
	Assert(1 == 0);
	return NULL;
	// need to implement the sampling methods
//  return new Lafortune(nLobes, lobes, wi, N, dPdu);
}
#endif

//ours
BRDF *CreateIridescence(const Spectrum & reflectance, const Normal &
			normal, const Float XYZ2RGBmatrix[3][3], const Float colorCurves[95][4])
{
	return new Iridescence(reflectance, normal, XYZ2RGBmatrix, colorCurves);
}

BRDF *CreateTexturedBRDF(const Spectrum & surfColor)
{
	return new TexturedBRDF(surfColor);
}


Spectrum Lambertian::Sample(Float u[2], Vector * wi, Float * pdf) const
{

	Float u0 = 2 * u[0] - 1.;
	Float u1 = 2 * u[1] - 1.;
	if (u0 * u0 + u1 * u1 > 1.) {
		*pdf = 0.;
		return Spectrum(0.);
	}

	Vector Du, Dv;
	if (N.x == 0. && N.y == 0.) {
		Du = Vector(1, 0, 0);
		Dv = Vector(0, 1, 0);
	} else {
		Du = Cross(Vector(N.y, N.x, 0.), Vector(N)).Hat();
		Dv = Cross(Du, Vector(N)).Hat();
	}

	*wi = u0 * Du + u1 * Dv + sqrt(1. - (u0 * u0 + u1 * u1)) * Vector(N);
	*pdf = Dot(N, *wi) / M_PI;

	return fr(*wi);
}

Spectrum BlinnGlossy::Sample(Float u[2], Vector * wi, Float * pdf) const
{
	// YOUR CODE HERE
  //#ifdef NOTDEF
  Float shininess = invRoughness;
  //Float alpha = acos(pow(2*M_PI*u[0]/(invRoughness+2), 1./shininess));
  Float alpha = acos(pow(u[0], 1./(shininess+2)));
  Float theta = 2*M_PI*u[1];
  Point P(sin(alpha)*cos(theta), sin(alpha)*sin(theta), cos(alpha));
  Vector H(P.x, P.y, P.z);
  H.Normalize();

  //-wo - 2. * Dot(N, -wo) * Vector(N)

  //Vector W = 2*Dot(wo.Hat(), H)*H - wo.Hat();
  Vector W = -wo -2. * Dot(H, -wo) * H;

  *wi = W;
  *pdf = 2*M_PI*pow(cos(alpha), shininess)/(shininess+2);// may be upside
							 // down
  //fprintf(stderr, "alpha %f, shininess %f, H.x %f, W.x %f\n", alpha,
  //	 shininess, H.x, W.x);
  //wi is the direction of the hemisphere to sample.  You want to sample
  //this according to the Blinn distribution

  return fr(*wi);
  //#endif //NOTDEF

  // return the value of the brdf at wi
  //	return Spectrum(0.);
}

Spectrum ScatteringMixture::Sample(Float u[2], Vector * wi, Float * pdf) const
{
	int fnum = int (RandomFloat() * funcs.size());
	funcs[fnum]->Sample(u, wi, pdf);
	*pdf /= funcs.size();
	return fr(*wi);
}

Float Lambertian::Pdf(const Vector & wi) const
{
	Float costheta = Dot(wi, N);
	if (costheta > 0.) {
		return 1. / (M_PI * costheta);
	} else {
		return 0.;
	}
}

Float BlinnGlossy::Pdf(const Vector & wi) const
{
	// YOUR CODE HERE

	return 0.;
}

Float ScatteringMixture::Pdf(const Vector & wi) const
{
	Float pdfSum = 0.;
	for (u_int i = 0; i < funcs.size(); ++i)
		pdfSum += funcs[i]->Pdf(wi);
	return pdfSum / funcs.size();
}

//ours

Spectrum Iridescence::ReflectedLight(const Spectrum & de, const ShadeContext &sc, const Vector &wi, HitInfo *hi) 
 {

   // THE ONLY clamping lrt does is to the color after the integrator returns.

   // hacks to pass info to fr()
   Float colorIn[3];
   de.ConvertToRGB(colorIn);
   DE = Spectrum(colorIn[0], colorIn[1], colorIn[2]);
   wo = sc.wo;

   // get wing color
   //ours-new stuff
   //Spectrum Cs = fr(wi) * R; 
   Spectrum Cs = fr(wi);


   // SHOULDN'T CLAMP color AT ALL NOW -- LET TRANSPORT.CC DO IT RIGHT BEFORE IT
   // RETURNS THE COLOR

   //ours-new stuff
   // clamp output color

   /*
   Float reflectC[3], maxVal;
   Cs.ConvertToRGB(reflectC);
   
   if (reflectC[0] > reflectC[1]) {
     maxVal = reflectC[0] > reflectC[2] ? reflectC[0] : reflectC[2];
   }
   else {
     maxVal = reflectC[1] > reflectC[2] ? reflectC[1] : reflectC[2];
   }
   
   if (maxVal > 1.) {
     Cs /= maxVal;
		      
   }
   */

   // now do metalic reflection

   ButterflyWingSurface *bws = (ButterflyWingSurface *)hi->hitPrim->attributes->Surface;
   Float shadeKs = sc.InitializeFloat(RI_KS, bws->getKs());
   Float shadeKr = sc.InitializeFloat(RI_KR,  bws->getKr());
   
   if (shadeKs > 0. || shadeKr > 0.) {
     ScatteringMixture *mix = CreateScatteringMixture();

     // if wing has glossy highlight
     if (shadeKs > 0.) {
       Float shadeRoughness = sc.InitializeFloat(RI_ROUGHNESS,  bws->getRoughness());
       mix->AddFunction(CreateBlinnGlossy(shadeKs * Cs,
					  shadeRoughness, sc.Ns, sc.wo));
     }
     
     // if wing has mirror highlight
     if (shadeKr > 0.) {
       mix->AddFunction(CreateSpecularReflection(shadeKr * Cs,
						 sc.Ns, sc.wo));
     }
     
     
     Spectrum retSpec = de * mix->fr(wi);
     delete mix;
     
     return retSpec;
   }
   else return Cs;
}

Spectrum TexturedBRDF::ReflectedLight(const Spectrum & de, const
				     ShadeContext &sc, const Vector &wi,
				     HitInfo *hi) const {
  return fr(wi);

}
Spectrum TexturedBRDF::fr(const Vector &wi) const {
  return surfColor;
}

Spectrum TexturedBRDF::Sample(Float u[2], Vector * wi, Float * pdf) const {
  return Spectrum(0.);
}

Float TexturedBRDF::Pdf(const Vector & wi) const {
  return 0.;
}


Spectrum Iridescence::fr(const Vector &wi) const {

  const int WAVELENGTHS = 95;
  const int dlambda = 5;
  const Float spectrumHeight = 1/(WAVELENGTHS * (Float)dlambda);

  // this is the spectrum that exits butterfly scales
  Float spectrumOut[WAVELENGTHS];

  // don't shade the side of primitive facing away from light
  //Float costheta = Dot(wi, N);
  Float costheta = Dot(wo, N);
  if (costheta > 0.) {
    int l = 12; // number of mullions
    int interMullion = 150; // space between mullions
    int mullionThickness = 50;
    Float ri = 1.53; // refractive index of mullions
    Float t = interMullion * costheta + mullionThickness * sqrt(ri*ri - (1 - costheta*costheta)); 
    Float r, g, b;
    Float mod;


#define NOTREADY2
#ifdef NOTREADY2
    // use Yw = 1 in the matrix in shading.cc
    // the intensity of our white light is constant over wavelength
    Float specIn[3];
    DE.ConvertToRGB(specIn);
   
    Float amplitude = sqrt((specIn[0] + specIn[1] + specIn[2])/3);
    for (int i=360; i <= 830; i += dlambda) {
      mod = sin(2*M_PI*(l+1)*t/(Float)i) / sin(2*M_PI*t/(Float)i);
      
      spectrumOut[(i-360)/dlambda] =  0.5 * amplitude * mod * mod;
    }

    // now convert spectrumOut to XYZ
    Float XSum = 0;
    Float YSum = 0;
    Float ZSum = 0;

    for (int i=0; i<WAVELENGTHS; i++) {
      XSum += spectrumOut[i] * colorCurves[i][1] * (Float)dlambda;
      YSum += spectrumOut[i] * colorCurves[i][2] * (Float)dlambda;
      ZSum += spectrumOut[i] * colorCurves[i][3] * (Float)dlambda;
    }

    Float k = 1/(106.857063); 
    Float X = k * XSum;
    Float Y = k * YSum; 
    Float Z = k * ZSum;
    

    //printf("xyz: %f %f %f\tsums: %f %f %f\n", X, Y, Z, XSum, YSum, ZSum);

    // now convert XYZ to RGB
    r = XYZ2RGBmatrix[0][0] * X + 
      XYZ2RGBmatrix[0][1] * Y +
      XYZ2RGBmatrix[0][2] * Z;

    g = XYZ2RGBmatrix[1][0] * X + 
      XYZ2RGBmatrix[1][1] * Y +
      XYZ2RGBmatrix[1][2] * Z;
    
    b = XYZ2RGBmatrix[2][0] * X + 
      XYZ2RGBmatrix[2][1] * Y +
      XYZ2RGBmatrix[2][2] * Z;

#endif //NOTREADY



#ifdef NOTREADY
    // use Yw = 100 in the matrix in shading.cc
    Float normFactor = 0;


    // the intensity of our white light is constant over wavelength
    Float amplitude = sqrt(spectrumHeight);
    for (int i=360; i <= 830; i += dlambda) {
      mod = sin(2*M_PI*(l+1)*t/(Float)i) / sin(2*M_PI*t/(Float)i);

      normFactor += 
	(spectrumOut[(i-360)/dlambda] =  0.5 * amplitude * mod * mod);
    }

    // NEED TO NORMALIZE SPECTRUMOUT -- THAT COULD BE THE PROBLEM
    Float invNF = 1./(normFactor * (Float)dlambda);

    /*
    for (int i=0; i<WAVELENGTHS; i++) {
    printf("white light %f, outlight%f\n", spectrumHeight, spectrumOut[i]);
    }
    */
    // now convert spectrumOut to XYZ
    Float XSum = 0;
    Float YSum = 0;
    Float ZSum = 0;


    for (int i=0; i<WAVELENGTHS; i++) {
      XSum += invNF * spectrumOut[i] * colorCurves[i][1] * (Float)dlambda;
      YSum += invNF * spectrumOut[i] * colorCurves[i][2] * (Float)dlambda;
      ZSum += invNF * spectrumOut[i] * colorCurves[i][3] * (Float)dlambda;
    }

    Float k = 100/(spectrumHeight * 106.857063);  // this is height of white light
    Float X = k * XSum;
    Float Y = k * YSum; 
    Float Z = k * ZSum;    
    
    // test -- white light should have X=100, Y=100, Z=100 and this should
    // be RGB = 1,1,1
    // X = 100; Y = 100; Z = 100;
    // this test WORKS!  it gives me a RGB of 1,1,1
    // no light should have X = Y = Z = 0; and RGB of 0,0,0
    //X = 0; Y = 0; Z = 0;
    // this works too!
    //X = 50; Y = 50; Z = 50;
    // this works too!  it gave me an RGB or .5, .5, .5
    

    //printf("xyz: %f %f %f\tsums: %f %f %f\n", X, Y, Z, XSum, YSum, ZSum);

    // now convert XYZ to RGB
    r = XYZ2RGBmatrix[0][0] * X + 
      XYZ2RGBmatrix[0][1] * Y +
      XYZ2RGBmatrix[0][2] * Z;

    g = XYZ2RGBmatrix[1][0] * X + 
      XYZ2RGBmatrix[1][1] * Y +
      XYZ2RGBmatrix[1][2] * Z;
    
    b = XYZ2RGBmatrix[2][0] * X + 
      XYZ2RGBmatrix[2][1] * Y +
      XYZ2RGBmatrix[2][2] * Z;


#endif //NOTREADY

#ifdef THREECOLORSPEC
    Float ampl[3];
    Spectrum amplSpec = DE.Pow(Spectrum(0.5, 0.5, 0.5));
    amplSpec.ConvertToRGB(ampl);

    mod = sin(2*M_PI*(l+1)*t/650) / sin(2*M_PI*t/650);
    r = 0.5 * ampl[0] * mod * mod;

    mod = sin(2*M_PI*(l+1)*t/510) / sin(2*M_PI*t/510);
    g = 0.5 * ampl[1] * mod * mod;

    mod = sin(2*M_PI*(l+1)*t/475) / sin(2*M_PI*t/475);
    b = 0.5 * ampl[2] * mod * mod;
#endif //3COLORSPEC

#ifdef DEBUGGING
    Float result[3];
    R.ConvertToRGB(result);
    printf("R is %f, %f, %f\n", result[0], result[1], result[2]);
#endif //DEBUGGING

    return Spectrum(r, g, b) ;
  } else {
    return Spectrum(0.);
  }

}

Spectrum Iridescence::Sample(Float u[2], Vector * wi, Float * pdf) const {
  return Spectrum(0.);
}

Float Iridescence::Pdf(const Vector & wi) const {
  return 0.;
}
