#! /usr/local/bin/perl

# Steven Bennett -- 06/03/2001
# ----------------------------
# This program takes a MaxMan
# rib and turnsit into something
# that LRT will read with
# relatively few errors or 
# warnings.


&main;

sub main
  {
    my $infile, $outfile, $name;
    my $line;
    my $texture_next_surface = "NO";
    my $texture_name;

    $infile = $ARGV[0];
    $outfile = "lrt" . "_" . "$infile";
    $name= "error";
    ($name) = $infile =~ m/(.*).rib/;
    open (IN, "$infile");
    open (OUT, ">$outfile");
	
    while($line = <IN>)
      {
	$line =~ s/Sides 1/# Sides 1/;
	
	$line =~ s/ReverseOrientation/# ReverseOrientation/;

	$line =~ s/Scale 1e\+031 1e\+031 1e\+031/# Scale 1e\+031 1e\+031 1e\+031/;

	$line =~ s/CoordinateSystem/# CoordinateSystem/;

	$line =~ s/Declare "u1"/# Declare "u1"/;

	$line =~ s/Declare "v1"/# Declare "v1"/;

	$line =~ s/"u1"/"s"/;

	$line =~ s/"v1"/"t"/;

	$line =~ s/-5e/-5.00e/;

	$line =~ s/-9e/-9.00e/;

	if ($line =~ m/^WorldBegin/)
	  {
	    $line .= "Attribute \"render\" \"sample\" \"light\"\n"
	  }

	if ($line =~ m/^FrameBegin/)
	  {
	    $line = "Option \"render\" \"integrator\" \"montecarlo\"\n" . $line;
	  }
	
	if ($line =~ m/LightSource/)
	  {
	    # old test light
	    $line = "LightSource \"distantlight\" 1 \"to\" [-7.59638
-273.63 74.4343] \"lightcolor\" [1 1 1] \"from\" [-7.59638 -292.948 79.6107] \"intensity\" 4\n";
	
	    # correct area lighting
	    $line = "Attribute \"light\" \"shadows\" \"on\" \"nsamples\" 100\nAttributeBegin\nConcatTransform [-1.49012e-008 -1 -2.98023e-008 0 -2.98023e-008 -1.49012e-008 1 0 -1 2.98023e-008 0 0 -429.122 -943.711 179.03 1]\nAreaLightSource \"diffuse\" 1 \"intensity\" 4500. \"lightcolor\" [ 1.0 1.0 1.0]\nSphere 16.0 -16 16 360\nAttributeEnd\nIlluminate 1 1\n";
	  }

	if ($line =~ m/ReadArchive/)
	  {
	    $line = "\n\n";
	  }
	
	if ($line =~ m/Display/)
	  {
	    $line = "ShadingRate 1\nPixelSamples 3 3\n# PixelFilter \"catmull-rom\" 1 1\nQuantize \"rgba\" 255 0 255 0.5\n# Declare\"jitterperbucket\" \"float\"\n# Hider \"hidden\" \"jitter\" [1]\n# Option \"limits\" \"eyesplits\" [3]\nShadingInterpolation \"smooth\"\nFormat 320 240 1\nDisplay \"$name.tiff\" \"file\" \"rgba\"\n";
	  }

	# prepare texture stuff - add texture info here as necessary

	
	# other leaves and stems

	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_1/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_1_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_2/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_2_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_3/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_3_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_4/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_4_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_5/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_5_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_6/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_6_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/leaf_7/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_7_map.tiff";
	  }


	if ( ($line =~ m/^Attribute/) && ($line =~ m/u_l_border/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "ul_bord_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/u_r_border/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "ur_bord_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/l_l_border/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "ll_bord_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/l_r_border/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "lr_bord_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/u_l_surfac/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "ul_surf_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/u_r_surfac/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "ur_surf_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/l_l_surfac/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "ll_surf_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/l_r_surfac/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "lr_surf_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/main_leaf/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "leaf_map.tiff";
	  }
	if ( ($line =~ m/^Attribute/) && ($line =~ m/butt_body/) )
	  {
	    $texture_next_surface = "YES";
	    $texture_name = "body_texture.tiff";
	  }



	# if we have detected a texture, modify the surface parameters
	# for the RIB.

	if ( ($line =~ m/^Surface/) && ($texture_next_surface eq "NO") )
	  {
	    $line = "Surface \"matte\"\n";
	  }
	
	if ( ($line =~ m/^Surface/) && ($texture_next_surface eq "YES") )
	  {

	    if ($texture_name =~ m/leaf_map/)
	      {
		$line = "Color [.60 .60 .60]\n" . "Surface \"texturedsurface\" \"texturename\" \"$texture_name\"\n";
	      }

	    elsif ($texture_name =~ m/bord/)
	      {
		$line = "Color [.55 .55 .55]\n" . "Surface \"texturedsurface\" \"texturename\" \"$texture_name\"\n";
	      }

	    elsif ($texture_name =~ m/surf/)
	      {
		$line = "Color [1.0 1.0 1.0]\n" . "Surface \"butterflywing\" \"Kd\" 1.0 \"Ks\" 0.1 \"Kr\" 0.1 \"roughness\" 1.0 \"texturename\" \"$texture_name\"\n";
	      }
	    else
	      {
		$line = "Surface \"texturedsurface\" \"texturename\" \"$texture_name\"\n";
		$texture_next_surface = "NO";
	      }
	  }

	print OUT "$line"
      }

    close(IN);
    close(OUT);
  }


