class MultiLayerInterference:public BRDF { public:
  MultiLayerInterference(const Spectrum & reflectance, const Normal & normal) {
    R = reflectance;
    N = normal;
  } Spectrum fr(const Vector & wi) const;
  
  // these are used for sampling the microfacet distribution --
  // hopefully we won't need these since an insect is "fuzzy" and
  // therefore diffuse. 
  Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;
  
  Float Pdf(const Vector & wi) const;

private:
  
  Spectrum R;
  Normal N;
  
};

// here's the meat of our program
Spectrum MultiLayerInterference::fr(const Vector &wi) const {
  // don't shade the side of primitive facing away from light
  Float costheta = Dot(wi, N);
  if (costheta > 0.) {
    // include physics for iridescence
    // need to know what wavelength we should associate with R, G, B
    // assume R = 650 nm, G = 510, B = 475

    // fudge factors -- ideally, need to change the parser to accept a
    // parameter for number of layers, but just put in here
    // parameters specific to morpho butterflies
    int l = 12; // number of mullions
    int interMullion = 150; // space between mullions
    int mullionThickness = 50;
    Float ri = 1.53; // refractive index of mullions
    int t = interMullion * costheta 
      + mullionThickness * sqrt(ri*ri - (1 - costheta*costheta)); 

    Float r, g, b;
    Float mod;

    mod = sin(2*M_PI*(l+1)*t/650) / sin(2*M_PI*t/650);
    r = 0.5 * mod * mod;

    mod = sin(2*M_PI*(l+1)*t/510) / sin(2*M_PI*t/510);
    g = 0.5 * mod * mod;

    mod = sin(2*M_PI*(l+1)*t/475) / sin(2*M_PI*t/475);
    b = 0.5 * mod * mod;

    return Spectrum(r, g, b);
  } else {
    return Spectrum(0.);
  }

}

Spectrum MultiLayerInterferece::Sample() const {
  return Spectrum(0.);
}

Float MultiLayerInterference::Pdf() const {
  return 0.;
}
