#ifndef G_MATH_H
#define G_MATH_H

#include <stdlib.h>
#include <math.h>


//
//	useful types
//

typedef float vec_t;
typedef float vec2_t[2];
typedef float vec3_t[3];
typedef float vec4_t[4];
typedef float *vec3_ptr;
typedef float mat3_t[3][3];
typedef float mat4_t[4][4];

typedef float bounding_box_t[6];	// min x, max x, min y, max y, min z, max z


#ifndef __cplusplus

typedef int bool;

#ifndef TRUE
#define TRUE	(1)
#endif

#ifndef FALSE
#define FALSE	(0)
#endif

#endif // __cplusplus


//
//	useful macros
//

#define VectorDot(a, b)				((a)[0]*(b)[0] + (a)[1]*(b)[1] + (a)[2]*(b)[2])
#define VectorDot4(a, b)			((a)[0]*(b)[0] + (a)[1]*(b)[1] + (a)[2]*(b)[2] + (a)[3]*(b)[3])
#define VectorCross(a, b, r)		(r[0] = ((a[1] * b[2]) - (b[1] * a[2])), r[1] = ((a[2] * b[0]) - (a[0] * b[2])), r[2] = ((a[0] * b[1]) - (a[1] * b[0])))
#define VectorLen(a)				((float) sqrt(VectorDot(a, a)))

#define VectorSet(x, y, z, v)		((v)[0] = (x), (v)[1] = (y), (v)[2] = (z))
#define VectorSet4(x, y, z, w, v)	((v)[0] = (x), (v)[1] = (y), (v)[2] = (z), (v)[3] = (w))
#define VectorCopy(s, d)			((d)[0] = (s)[0], (d)[1] = (s)[1], (d)[2] = (s)[2])

#define VectorAdd(a, b, r)			(r[0] = a[0] + b[0], r[1] = a[1] + b[1], r[2] = a[2] + b[2])
#define VectorSubtract(a, b, r)		(r[0] = a[0] - b[0], r[1] = a[1] - b[1], r[2] = a[2] - b[2])
#define VectorScale(a, s, r)		(r[0] = a[0] * (s), r[1] = a[1] * (s), r[2] = a[2] * (s))
#define VectorMA(a, b, s, r)		(r[0] = a[0] + (s) * b[0], r[1] = a[1] + (s) * b[1], r[2] = a[2] + (s) * b[2])

#define VectorNegate(v)				((v)[0] = -(v)[0], (v)[1] = -(v)[1], (v)[2] = -(v)[2])

#define PointInBox(p, b)			(((b)[0] < (p)[0] && (p)[0] < (b)[1] && (b)[2] < (p)[1] && (p)[1] < (b)[3] && (b)[4] < (p)[2] && (p)[2] < (b)[5]) ? (1) : (0)) 

#ifndef MAX
#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a, b) (((a) < (b)) ? (a) : (b))
#endif


//
//	prototypes
//

float   Clamp(float value, float min, float max);

float	VectorNormalize(vec3_t vec);
void	VectorPerp(vec3_t src, vec3_t dst);
float	RandomRange(float lo, float high);
void	ProjectPointOnPlane(vec3_t src, vec3_t normal, vec3_t dst);

void	MatrixApply3(mat3_t mat, vec3_t src, vec3_t dst);
void	MatrixApply4(mat4_t mat, vec4_t src, vec4_t dst);

void	MatrixMult3(mat3_t a, mat3_t b, mat3_t dst);
void	MatrixMult4(mat4_t a, mat4_t b, mat4_t dst);

void    MatrixTranspose3(mat3_t m);
void    MatrixTranspose4(mat4_t m);


#endif // G_MATH_H