#include "g_math.h"


//
//  Clamp
//

float
Clamp(float value, float min, float max)
{
    if (value < min)
    {
        return min;
    }
    
    if (value > max)
    {
        return max;
    }
    
    return value;
}


//
//	VectorNormalize
//

float
VectorNormalize(vec3_t vec)
{
	float len = VectorLen(vec);
	float rlen = 1.0f / len;

	if (len)
	{
		vec[0] *= rlen;
		vec[1] *= rlen;
		vec[2] *= rlen;
	}

	return len;
}


//
//	RandomRange
//

float
RandomRange(float lo, float hi)
{
	float x = (float) (rand() & 0x7fff) / (float) 0x7fff;
	return (x * (hi - lo) + lo);
}


//
//	VectorPerp
//

void
VectorPerp(vec3_t src, vec3_t dst)
{
	int i, pos = 0;
	float min = 1.0f;
	vec3_t temp_vec;

	for (i = 0; i < 3; i++)
	{
		if (fabs(src[i]) < min)
		{
			pos = i;
			min = (float) fabs(src[i]);
		}
	}

	temp_vec[0] = temp_vec[1] = temp_vec[2] = 0.0f;
	temp_vec[pos] = 1.0f;

	ProjectPointOnPlane(temp_vec, src, dst);

	VectorNormalize(dst);
}


//
//	ProjectPointOnPlane
//

void
ProjectPointOnPlane(vec3_t src, vec3_t normal, vec3_t dst)
{
	float d = VectorDot(src, normal);

	VectorMA(src, normal, -d, dst);
}


//
//	MatrixApply3
//

void
MatrixApply3(mat3_t mat, vec3_t src, vec3_t dst)
{
	dst[0] = VectorDot(mat[0], src);
	dst[1] = VectorDot(mat[1], src);
	dst[2] = VectorDot(mat[2], src);
}


//
//	MatrixApply4
//

void
MatrixApply4(mat4_t mat, vec4_t src, vec4_t dst)
{
	dst[0] = VectorDot4(mat[0], src);
	dst[1] = VectorDot4(mat[1], src);
	dst[2] = VectorDot4(mat[2], src);
	dst[3] = VectorDot4(mat[3], src);
}


//
//	MatrixMult3
//

void
MatrixMult3(mat3_t a, mat3_t b, mat3_t dst)
{
    dst[0][0] = a[0][0]*b[0][0] + a[0][1]*b[1][0] + a[0][2]*b[2][0];
    dst[0][1] = a[0][0]*b[0][1] + a[0][1]*b[1][1] + a[0][2]*b[2][1];
    dst[0][2] = a[0][0]*b[0][2] + a[0][1]*b[1][2] + a[0][2]*b[2][2];

    dst[1][0] = a[1][0]*b[0][0] + a[1][1]*b[1][0] + a[1][2]*b[2][0];
    dst[1][1] = a[1][0]*b[0][1] + a[1][1]*b[1][1] + a[1][2]*b[2][1];
    dst[1][2] = a[1][0]*b[0][2] + a[1][1]*b[1][2] + a[1][2]*b[2][2];

    dst[2][0] = a[2][0]*b[0][0] + a[2][1]*b[1][0] + a[2][2]*b[2][0];
    dst[2][1] = a[2][0]*b[0][1] + a[2][1]*b[1][1] + a[2][2]*b[2][1];
    dst[2][2] = a[2][0]*b[0][2] + a[2][1]*b[1][2] + a[2][2]*b[2][2];
}


//
//	MatrixMult4
//

void
MatrixMult4(mat4_t a, mat4_t b, mat4_t dst)
{
    dst[0][0] = a[0][0]*b[0][0] + a[0][1]*b[1][0] + a[0][2]*b[2][0] + a[0][3]*b[3][0];
    dst[0][1] = a[0][0]*b[0][1] + a[0][1]*b[1][1] + a[0][2]*b[2][1] + a[0][3]*b[3][1];
    dst[0][2] = a[0][0]*b[0][2] + a[0][1]*b[1][2] + a[0][2]*b[2][2] + a[0][3]*b[3][2];
    dst[0][3] = a[0][0]*b[0][3] + a[0][1]*b[1][3] + a[0][2]*b[2][3] + a[0][3]*b[3][3];

    dst[1][0] = a[1][0]*b[0][0] + a[1][1]*b[1][0] + a[1][2]*b[2][0] + a[1][3]*b[3][0];
    dst[1][1] = a[1][0]*b[0][1] + a[1][1]*b[1][1] + a[1][2]*b[2][1] + a[1][3]*b[3][1];
    dst[1][2] = a[1][0]*b[0][2] + a[1][1]*b[1][2] + a[1][2]*b[2][2] + a[1][3]*b[3][2];
    dst[1][3] = a[1][0]*b[0][3] + a[1][1]*b[1][3] + a[1][2]*b[2][3] + a[1][3]*b[3][3];

    dst[2][0] = a[2][0]*b[0][0] + a[2][1]*b[1][0] + a[2][2]*b[2][0] + a[2][3]*b[3][0];
    dst[2][1] = a[2][0]*b[0][1] + a[2][1]*b[1][1] + a[2][2]*b[2][1] + a[2][3]*b[3][1];
    dst[2][2] = a[2][0]*b[0][2] + a[2][1]*b[1][2] + a[2][2]*b[2][2] + a[2][3]*b[3][2];
    dst[2][3] = a[2][0]*b[0][3] + a[2][1]*b[1][3] + a[2][2]*b[2][3] + a[2][3]*b[3][3];

    dst[3][0] = a[3][0]*b[0][0] + a[3][1]*b[1][0] + a[3][2]*b[2][0] + a[3][3]*b[3][0];
    dst[3][1] = a[3][0]*b[0][1] + a[3][1]*b[1][1] + a[3][2]*b[2][1] + a[3][3]*b[3][1];
    dst[3][2] = a[3][0]*b[0][2] + a[3][1]*b[1][2] + a[3][2]*b[2][2] + a[3][3]*b[3][2];
    dst[3][3] = a[3][0]*b[0][3] + a[3][1]*b[1][3] + a[3][2]*b[2][3] + a[3][3]*b[3][3];
}


//
//  MatrixTranspose3
//

void
MatrixTranspose3(mat3_t m)
{
    float swap;

    swap    = m[1][0];
    m[1][0] = m[0][1];
    m[0][1] = swap;

    swap    = m[2][0];
    m[2][0] = m[0][2];
    m[0][2] = swap;

    swap    = m[2][1];
    m[2][1] = m[1][2];
    m[1][2] = swap;
}


//
//  MatrixTranspose4
//

void
MatrixTranspose4(mat4_t m)
{
    float swap;

    swap    = m[1][0];
    m[1][0] = m[0][1];
    m[0][1] = swap;

    swap    = m[2][0];
    m[2][0] = m[0][2];
    m[0][2] = swap;

    swap    = m[2][1];
    m[2][1] = m[1][2];
    m[1][2] = swap;

    swap    = m[3][0];
    m[3][0] = m[0][3];
    m[0][3] = swap;

    swap    = m[2][3];
    m[2][3] = m[3][2];
    m[3][2] = swap;

    swap    = m[3][1];
    m[3][1] = m[1][3];
    m[1][3] = swap;
}