
#ifndef TRIMESH_H
#define TRIMESH_H
#include "primitives.h"



class FurryMesh;


class TriangleMesh:public Primitive {
  public:

	TriangleMesh(int ntris, int nverts, int *vptr, Point * P,
				 PrimitiveAttributes * a, SurfaceFunction * v);
	~TriangleMesh();

	BBox BoundObjectSpace() const;

	BBox BoundWorldSpace() const;

	bool CanIntersect() const {
		return false;
	} void Refine(vector < Primitive * >*refined) const;

	friend class Triangle;
	friend class FurryTriangle;

  protected:
	 int ntris;
	int nverts;
	int *vertexIndex;
	Point *p;

};

struct FurryMeshVertex
{
    Point   p_base;
    Point   p_tip;
};

//
//  FurryMesh
//

class FurryMesh
{
    public:
        FurryMesh(
            int     num_tris,
            int     num_verts,
            int    *indices,
            Point  *vertices,
            SurfaceFunction *fur_surface);
        
        int m_numtris;
        int m_numverts;
        FurryMeshVertex *m_vertices;
};



class Triangle:public Primitive { public:
	 Triangle(const TriangleMesh * m, int n)
	:Primitive(m->attributes, NULL) {
		attributes->Reference();
		mesh = m;
		triNum = n;
	}
	
	virtual BBox BoundObjectSpace() const;
	virtual BBox BoundWorldSpace() const;

	virtual bool IntersectClosest(const Ray & ray, Float mint, Float * maxt,
						  HitInfo * hit) const;

  protected:

	const TriangleMesh *mesh;
	int triNum;

};

//
//  FurryTriangle
//
//  A texel-shaded triangle.
//

class FurryTriangle : public Triangle
{
    public:
        FurryTriangle(const TriangleMesh *m, int n, FurryMesh *in_furmesh, PrimitiveAttributes *a, SurfaceFunction *v);
        
        virtual BBox BoundObjectSpace() const;
        virtual BBox BoundWorldSpace() const;
        
        virtual bool IntersectClosest(
            const Ray  &ray,
            Float       mint,
            Float      *maxt,
			HitInfo    *hit) const;
			
	    float IntersectSingle(const Ray &ray, Point &v0, Point &v1, Point &v2) const;
	    
	    float FurryTriangle::IntersectOutside(const Ray &ray);
	    
	    Point InverseMapTexel(const Point &p);
			
	    FurryMesh *furmesh;
	    
	    Point *p0_base;
	    Point *p0_tip;
	    Point *p1_base;
	    Point *p1_tip;
	    Point *p2_base;
	    Point *p2_tip;
};


#endif // TRIMESH_H
