
#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"

class Integrator {
  public:

	virtual ~Integrator();

	virtual Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
							   Float * hitDist, Float * alpha) const = 0;

};

class ColorIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RayCastingIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class WhittedIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
};

class MCIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RendermanIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
  private:
	 mutable StringHashTable shaders;
};

//
//  FurIntegrator
//
//  Uses texel rendering for fur.
//

class FurIntegrator : public Integrator
{
    public:
    
        FurIntegrator();
    
	    Spectrum Integrate(
	        const Ray   &ray,
	        HitInfo     *hitInfo,
            Float       *hitDist,
            Float       *alpha) const;
            
    static int RayDepth;              
};


#endif // TRANSPORT_H
