#ifndef RI_H
#define RI_H
#ifdef __cplusplus
extern "C" {
#endif							/* C++ */
	 typedef short RtBoolean;
	typedef int RtInt;
	typedef float RtFloat;
	typedef char *RtToken;
	typedef RtFloat RtColor[3];
	typedef RtFloat RtPoint[3];
	typedef char *RtString;
	typedef void *RtPointer;
	typedef void RtVoid;
	typedef RtFloat RtMatrix[16];
	typedef RtFloat(*RtFilterFunc) (RtFloat, RtFloat, RtFloat, RtFloat);
	typedef RtVoid(*RtFunc) ();
	typedef RtPointer RtObjectHandle;
	typedef RtPointer RtLightHandle;
	typedef RtVoid(*RtErrorHandler) (RtInt code, RtInt severity,
									 char *msg);
	typedef RtFloat RtBasis[16];
	typedef RtFloat RtBound[6];
#define RI_FALSE    0
#define RI_TRUE     1
#define RI_INFINITY (RtFloat)1.0e38
#define RI_EPSILON  (RtFloat)1.0e-10
#define RI_NULL     NULL
	extern RtBasis RiBezierBasis, RiBSplineBasis, RiCatmullRomBasis,
		RiHermiteBasis, RiPowerBasis;

#define RI_BEZIERSTEP		((RtInt)3)
#define RI_BSPLINESTEP		((RtInt)1)
#define RI_CATMULLROMSTEP	((RtInt)1)
#define RI_HERMITESTEP		((RtInt)2)
#define RI_POWERSTEP		((RtInt)4)
	extern RtToken RI_A, RI_ABORT, RI_AMBIENTLIGHT, RI_AMPLITUDE, RI_AZ,
		RI_BACKGROUND, RI_BEAMDISTRIBUTION, RI_BICUBIC, RI_BILINEAR,
		RI_BLACK, RI_BUMPY, RI_CAMERA, RI_CLAMP, RI_COMMENT, RI_CONEANGLE,
		RI_CONEDELTAANGLE, RI_CONSTANT, RI_CS, RI_DEPTHCUE, RI_DIFFERENCE,
		RI_DISTANCE, RI_DISTANTLIGHT, RI_FILE, RI_FLATNESS, RI_FOG, RI_FOV,
		RI_FRAMEBUFFER, RI_FROM, RI_HANDLER, RI_HIDDEN, RI_IDENTIFIER,
		RI_IGNORE, RI_INSIDE, RI_INTENSITY, RI_INTERSECTION, RI_KA, RI_KD,
		RI_KR, RI_KS, RI_LH, RI_LIGHTCOLOR, RI_MATTE, RI_MAXDISTANCE,
		RI_METAL, RI_MINDISTANCE, RI_N, RI_NAME, RI_NONPERIODIC, RI_NP,
		RI_OBJECT, RI_ORIGIN, RI_ORTHOGRAPHIC, RI_OS, RI_OUTSIDE, RI_P,
		RI_PAINT, RI_PAINTEDPLASTIC, RI_PERIODIC, RI_PERSPECTIVE,
		RI_PLASTIC, RI_POINTLIGHT, RI_PRIMITIVE, RI_PRINT, RI_PW, RI_PZ,
		RI_RASTER, RI_RGB, RI_RGBA, RI_RGBAZ, RI_RGBZ, RI_RH, RI_ROUGHNESS,
		RI_S, RI_SCREEN, RI_SHADINGGROUP, RI_SHINYMETAL, RI_SMOOTH,
		RI_SPECULARCOLOR, RI_SPOTLIGHT, RI_ST, RI_STRUCTURE, RI_T,
		RI_TEXTURENAME, RI_TO, RI_TRIMDEVIATION, RI_UNION, RI_WORLD, RI_Z;
	extern RtToken LRT_IMAGEVIEWER;
	extern RtToken LRT_RENDER, LRT_DISPLAY;
	extern RtToken LRT_INTEGRATOR, LRT_SHADOWS, LRT_COLOR;
	extern RtToken LRT_WHITTED, LRT_RMAN, LRT_MONTECARLO;
	extern RtToken LRT_FUR_RENDERER; // ec -- fur integrator token
	extern RtToken LRT_SURFACE, LRT_COMBINATION, LRT_SAMPLE;
	extern RtToken LRT_LIGHT, LRT_RAYCAST, LRT_NSAMPLES;
	extern RtToken LRT_VIEWST, LRT_GLASS, LRT_INDEX, LRT_KT;
	extern RtToken LRT_FUR; // ec -- fur surface
	extern RtToken LRT_TEXEL_SHADER; // ec -- texel shader token
	extern RtToken LRT_FUR_OPT_DENSITY; // ec
	extern RtToken LRT_FUR_INCREMENT; // ec
	extern RtToken LRT_FUR_HEIGHT; // ec -- height of fur from skin
	extern RtToken LRT_FUR_HEIGHT_NOISE; // ec -- height noise
	extern RtToken LRT_FUR_NORMAL_BIAS; // ec -- normal bias
	extern RtToken LRT_FUR_NORMAL_NOISE_BIAS; // ec -- normal noise bias
	extern RtToken LRT_CHECKERED, LRT_CHECKCOLOR1, LRT_CHECKCOLOR2;
	extern RtToken LRT_CHECKFREQUENCY, LRT_DIFFUSE;
	extern RtToken LRT_TYPE, LRT_SHUTTER;
	extern RtToken LRT_PINHOLE, LRT_MBDOF;
	extern RtToken LRT_IRIS, LRT_STRIPE;
	extern RtToken LRT_IRIS_RATE, LRT_STRIPE_WIDTH, LRT_STRIPE_DIRECTION;
	extern RtToken LRT_DOWN, LRT_UP, LRT_LEFT, LRT_RIGHT;
	extern RtToken LRT_FORMAT, LRT_BUCKETSIZE, LRT_GRIDSIZE,
		LRT_TEXTUREMEMORY;
	extern RtToken LRT_ZTHRESHOLD, LRT_EXTREMEDISPLACEMENT, LRT_EYESPLITS;
	extern RtToken LRT_GEOMMEMORY, LRT_BIAS0, LRT_BIAS1, LRT_SHADER,
		LRT_TEXTURE;
	extern RtToken LRT_VFXMASTER, LRT_VFXINSTANCE, LRT_ARCHIVE,
		LRT_RESOURCE;
	extern RtToken LRT_MINSAMPLES, LRT_MAXSAMPLES, LRT_MAX_RAYLEVEL,
		LRT_BRANCH_RATIO;
	extern RtToken LRT_MAX_BRANCH_RATIO, LRT_MINSHADOWBIAS, LRT_STEPS,
		LRT_MINPATCHSAMPLES;
	extern RtToken LRT_VERBOSITY, LRT_INCLUDE, LRT_REFRESH, LRT_FULLCOLOR;
	extern RtToken LRT_SETPOINTS, LRT_NAME, LRT_SHADINGGROUP, LRT_BINARY;
	extern RtToken LRT_COORDINATESYSTEM, LRT_SPHERE, LRT_SENSE,
		LRT_AVERAGECOLOR;
	extern RtToken LRT_EMISSIONCOLOR, LRT_PATCHSIZ, LRT_ELEMSIZE,
		LRT_MINSIZE;
	extern RtToken LRT_ZONAL, LRT_CASTS_SHADOWS, LRT_PATCH_MAXLEVEL,
		LRT_PATCH_MINLEVEL;
	extern RtToken LRT_PATCH_MULTIPLIER, LRT_TRUEDISPLACEMENT, LRT_CACHE;
	extern RtToken LRT_UDIVISIONS, LRT_VDIVISIONS, LRT_ORIGIN;
	extern RtToken LRT_MERGE, LRT_COMPRESSION, LRT_RESOLUTION,
		LRT_RESOLUTIONUNIT;
	extern RtToken LRT_JITTER, LRT_PDISC, LRT_FLATNESS, LRT_WIDTH,
		LRT_CONSTANTWIDTH;
	extern RtInt RiLastError;
	extern RtToken RiDeclare(char *name, char *type);
	extern RtVoid RiBegin(RtToken), RiEnd();
	extern RtVoid RiFrameBegin(RtInt), RiFrameEnd();
	extern RtVoid RiWorldBegin(), RiWorldEnd();
	extern RtVoid RiPixelSamples(RtFloat x, RtFloat y);
	extern RtVoid RiFormat(RtInt x, RtInt y, RtFloat aspect);
	extern RtVoid RiFrameAspectRatio(RtFloat aspect);
	extern RtVoid RiScreenWindow(RtFloat left, RtFloat right,
								 RtFloat bottom, RtFloat top);
	extern RtVoid RiCropWindow(RtFloat left, RtFloat right, RtFloat bottom,
							   RtFloat top);
	extern RtVoid RiClipping(RtFloat hither, RtFloat yon);
	extern RtVoid RiShutter(RtFloat time0, RtFloat time1);
	extern RtVoid RiDepthOfField(RtFloat fstop, RtFloat focallen,
								 RtFloat focaldist);
	extern RtVoid RiProjection(RtToken name, ...);
	extern RtVoid RiProjectionV(RtToken name, RtInt nArgs,
								RtToken tokens[], RtPointer params[]);
	extern RtVoid RiExposure(RtFloat gain, RtFloat gamma);
	extern RtVoid RiPixelFilter(RtFilterFunc filter, RtFloat xwidth,
								RtFloat ywidth);
	extern RtFloat RiBoxFilter(RtFloat x, RtFloat y, RtFloat xwidth,
							   RtFloat ywidth);
	extern RtFloat RiTriangleFilter(RtFloat x, RtFloat y, RtFloat xwidth,
									RtFloat ywidth);
	extern RtFloat RiCatmullRomFilter(RtFloat x, RtFloat y, RtFloat xwidth,
									  RtFloat ywidth);
	extern RtFloat RiGaussianFilter(RtFloat x, RtFloat y, RtFloat xwidth,
									RtFloat ywidth);
	extern RtFloat RiSincFilter(RtFloat x, RtFloat y, RtFloat xwidth,
								RtFloat ywidth);
	extern RtFloat RiMitchellFilter(RtFloat x, RtFloat y, RtFloat xwidth,
									RtFloat ywidth);
	extern RtVoid RiImager(RtToken name, ...);
	extern RtVoid RiImagerV(RtToken name, RtInt n, RtToken tokens[],
							RtPointer params[]);
	extern RtVoid RiQuantize(RtToken type, RtInt one, RtInt minimum,
							 RtInt maximum, RtFloat ditheramp);
	extern RtVoid RiDisplay(char *name, RtToken type, RtToken mode, ...);
	extern RtVoid RiDisplayV(char *name, RtToken type, RtToken mode,
							 int nArgs, RtToken tokens[],
							 RtPointer parameters[]);
	extern RtVoid RiHider(RtToken type, ...);
	extern RtVoid RiHiderV(RtToken type, RtInt n, RtToken tokens[],
						   RtPointer parms[]);
	extern RtVoid RiOption(RtToken name, ...);
	extern RtVoid RiOptionV(RtToken name, RtInt n, RtToken tokens[],
							RtPointer parms[]);
	extern RtVoid RiTransformBegin();
	extern RtVoid RiTransformEnd();
	extern RtVoid RiAttributeBegin();
	extern RtVoid RiAttributeEnd();
	extern RtVoid RiColor(RtColor Cs);
	extern RtVoid RiOpacity(RtColor Cs);
	extern RtVoid RiOrientation(RtToken orientation);
	extern RtVoid RiReverseOrientation();
	extern RtVoid RiSides(RtInt sides);
	extern RtVoid RiAttribute(RtToken name, ...);
	extern RtVoid RiAttributeV(RtToken name, RtInt n, RtToken tokens[],
							   RtPointer parms[]);
	extern RtVoid RiSurface(RtToken name, ...);
	extern RtVoid RiSurfaceV(RtToken name, RtInt n, RtToken tokens[],
							 RtPointer parms[]);
	extern RtVoid RiIdentity();
	extern RtVoid RiTransform(RtMatrix transform);
	extern RtVoid RiConcatTransform(RtMatrix transform);
	extern RtVoid RiPerspective(RtFloat fov);
	extern RtVoid RiTranslate(RtFloat dx, RtFloat dy, RtFloat dz);
	extern RtVoid RiRotate(RtFloat angle, RtFloat dx, RtFloat dy,
						   RtFloat dz);
	extern RtVoid RiScale(RtFloat sx, RtFloat sy, RtFloat sz);
	extern RtVoid RiCoordinateSystem(RtToken);
	extern RtVoid RiPolygon(RtInt nverts, ...);
	extern RtVoid RiPolygonV(RtInt nverts, RtInt n, RtToken tokens[],
							 RtPointer parms[]);
	RtVoid RiSphere(RtFloat radius, RtFloat zmin, RtFloat zmax,
					RtFloat thetamax, ...);
	RtVoid RiSphereV(RtFloat radius, RtFloat zmin, RtFloat zmax,
					 RtFloat thetaMax, RtInt n, RtToken tokens[],
					 RtPointer params[]);
	RtVoid RiPointsPolygons(RtInt npolys, RtInt nvertices[],
							RtInt vertices[], ...);
	RtVoid RiPointsPolygonsV(RtInt npolys, RtInt nvertices[],
							 RtInt vertices[], RtInt n, RtToken tokens[],
							 RtPointer params[]);
	extern RtVoid RiDisk(RtFloat height, RtFloat radius, RtFloat tmax,
						 ...);
	extern RtVoid RiDiskV(RtFloat height, RtFloat radius, RtFloat tmax,
						  RtInt n, RtToken tokens[], RtPointer parms[]);
	extern RtVoid RiNuPatch(RtInt nu, RtInt uorder, RtFloat * uknot,
							RtFloat umin, RtFloat umax, RtInt nv,
							RtInt vorder, RtFloat * vknot, RtFloat vmin,
							RtFloat vmax, ...);
	extern RtVoid RiNuPatchV(RtInt nu, RtInt uorder, RtFloat * uknot,
							 RtFloat umin, RtFloat umax, RtInt nv,
							 RtInt vorder, RtFloat * vknot, RtFloat vmin,
							 RtFloat vmax, RtInt n, RtToken tokens[],
							 RtPointer params[]);
	extern RtVoid RiTrimCurve(RtInt nloops, RtInt * ncurves, RtInt * order,
							  RtFloat * knot, RtFloat * amin,
							  RtFloat * amax, RtInt * n, RtFloat * u,
							  RtFloat * v, RtFloat * w);
	extern RtVoid RiBasis(RtBasis ubasis, RtInt ustep, RtBasis vbasis,
						  RtInt vstep);
	extern RtVoid RiPatch(RtToken type, ...);
	extern RtVoid RiPatchV(RtToken type, RtInt n, RtToken tokens[],
						   RtPointer params[]);
	extern RtVoid RiPatchMesh(RtToken type, RtInt nu, RtToken uwrap,
							  RtInt nv, RtToken vwrap, ...);
	extern RtVoid RiPatchMeshV(RtToken type, RtInt nu, RtToken uwrap,
							   RtInt nv, RtToken vwrap, RtInt n,
							   RtToken tokens[], RtPointer params[]);
	extern RtVoid RiCone(RtFloat height, RtFloat radius, RtFloat tmax,
						 ...);
	extern RtVoid RiConeV(RtFloat height, RtFloat radius, RtFloat tmax,
						  RtInt n, RtToken tokens[], RtPointer parms[]);
	extern RtVoid RiCylinder(RtFloat radius, RtFloat zmin, RtFloat zmax,
							 RtFloat tmax, ...);
	extern RtVoid RiCylinderV(RtFloat radius, RtFloat zmin, RtFloat zmax,
							  RtFloat tmax, RtInt n, RtToken tokens[],
							  RtPointer parms[]);
	extern RtVoid RiHyperboloid(RtPoint point1, RtPoint point2,
								RtFloat tmax, ...);
	extern RtVoid RiHyperboloidV(RtPoint point1, RtPoint point2,
								 RtFloat tmax, RtInt n, RtToken tokens[],
								 RtPointer parms[]);
	extern RtVoid RiParaboloid(RtFloat rmax, RtFloat zmin, RtFloat zmax,
							   RtFloat tmax, ...);
	extern RtVoid RiParaboloidV(RtFloat rmax, RtFloat zmin, RtFloat zmax,
								RtFloat tmax, RtInt n, RtToken tokens[],
								RtPointer parms[]);
	extern RtVoid RiTorus(RtFloat majrad, RtFloat minrad, RtFloat phimin,
						  RtFloat phimax, RtFloat tmax, ...);
	extern RtVoid RiTorusV(RtFloat majrad, RtFloat minrad, RtFloat phimin,
						   RtFloat phimax, RtFloat tmax, RtInt n,
						   RtToken tokens[], RtPointer parms[]);
	extern RtVoid RiProcedural(RtPointer data, RtBound bound,
							   RtFunc subdivfunc, RtFunc freefunc);
	extern RtVoid RiSolidBegin(RtToken);
	extern RtVoid RiSolidEnd();
	extern RtVoid RiGeneralPolygon(RtInt nloops, RtInt nverts[], ...);
	extern RtVoid RiGeneralPolygonV(RtInt nloops, RtInt nverts[], RtInt n,
									RtToken tokens[], RtPointer parms[]);
	extern RtVoid RiPointsGeneralPolygons(RtInt npolys, RtInt nloops[],
										  RtInt nverts[], RtInt verts[],
										  ...);
	extern RtVoid RiPointsGeneralPolygonsV(RtInt npolys, RtInt nloops[],
										   RtInt nverts[], RtInt verts[],
										   RtInt n, RtToken tokens[],
										   RtPointer parms[]);
	extern RtObjectHandle RiObjectBegin();
	extern void RiObjectEnd();
	extern RtLightHandle RiLightSource(RtToken name, ...);
	extern RtLightHandle RiLightSourceV(RtToken name, RtInt n,
										RtToken tokens[],
										RtPointer parms[]);
	extern RtLightHandle RiAreaLightSource(RtToken name, ...);
	extern RtLightHandle RiAreaLightSourceV(RtToken name, RtInt n,
											RtToken tokens[],
											RtPointer parms[]);
	extern RtVoid RiIlluminate(RtLightHandle light, RtBoolean on);
	extern RtVoid RiMotionBegin(RtInt N, ...);
	extern RtVoid RiMotionBeginV(RtInt N, RtFloat times[]);
	extern RtVoid RiMotionEnd();
	extern RtVoid RiPixelVariance(RtFloat variation);
	extern RtVoid RiTextureCoordinates(RtFloat s1, RtFloat t1, RtFloat s2,
									   RtFloat t2, RtFloat s3, RtFloat t3,
									   RtFloat s4, RtFloat t4);
	extern RtVoid RiShadingRate(RtFloat r);
	extern RtVoid RiShadingInterpolation(RtToken type);
	extern RtVoid RiRelativeDetail(RtFloat relativedetail);
	extern RtVoid RiMatte(RtBoolean onoff);
	extern RtVoid RiBound(RtBound bound), RiDetail(RtBound bound);
	extern RtVoid RiDetailRange(RtFloat minvis, RtFloat lowtran,
								RtFloat uptran, RtFloat maxvis);
	extern RtVoid RiGeometricApproximation(RtToken type, RtFloat value);
	extern RtVoid RiGeometricRepresentation(RtToken type);
	extern RtPoint *RiTransformPoints(RtToken fromspace, RtToken tospace,
									  RtInt npoints, RtPoint * points);
	extern RtVoid RiSkew(RtFloat, RtFloat, RtFloat, RtFloat, RtFloat,
						 RtFloat, RtFloat);
	extern RtVoid RiDeformation(RtToken name, ...);
	extern RtVoid RiDeformationV(RtToken name, RtInt n, RtToken tokens[],
								 RtPointer parms[]);
	extern RtVoid RiDisplacement(RtToken name, ...);
	extern RtVoid RiDisplacementV(RtToken name, RtInt n, RtToken tokens[],
								  RtPointer parms[]);
	extern RtVoid RiGeometry(RtToken type, ...);
	extern RtVoid RiGeometryV(RtToken type, RtInt n, RtToken tokens[],
							  RtPointer params[]);
	extern RtVoid RiCurves(RtToken degree, RtInt ncurves, RtInt nverts[],
						   RtToken wrap, ...);
	extern RtVoid RiCurvesV(RtToken degree, RtInt ncurves, RtInt nverts[],
							RtToken wrap, RtInt n, RtToken tokens[],
							RtPointer params[]);

	extern RtVoid RiPoints(RtInt npts, ...);
	extern RtVoid RiPointsV(RtInt npts, RtInt n, RtToken tokens[],
							RtPointer params[]);
	extern RtVoid RiMakeTexture(char *pic, char *tex, RtToken swrap,
								RtToken twrap, RtFilterFunc filterfunc,
								RtFloat swidth, RtFloat twidth, ...);
	extern RtVoid RiMakeTextureV(char *pic, char *tex, RtToken swrap,
								 RtToken twrap, RtFilterFunc filterfunc,
								 RtFloat swidth, RtFloat twidth, RtInt n,
								 RtToken tokens[], RtPointer params[]);
	extern RtVoid RiMakeBump(char *pic, char *tex, RtToken swrap,
							 RtToken twrap, RtFilterFunc filterfunc,
							 RtFloat swidth, RtFloat twidth, ...);
	extern RtVoid RiMakeBumpV(char *pic, char *tex, RtToken swrap,
							  RtToken twrap, RtFilterFunc filterfunc,
							  RtFloat swidth, RtFloat twidth, RtInt n,
							  RtToken tokens[], RtPointer params[]);
	extern RtVoid RiMakeLatLongEnvironment(char *pic, char *tex,
										   RtFilterFunc filterfunc,
										   RtFloat swidth, RtFloat twidth,
										   ...);
	extern RtVoid RiMakeLatLongEnvironmentV(char *pic, char *tex,
											RtFilterFunc filterfunc,
											RtFloat swidth, RtFloat twidth,
											RtInt n, RtToken tokens[],
											RtPointer params[]);
	extern RtVoid RiMakeCubeFaceEnvironment(char *px, char *nx, char *py,
											char *ny, char *pz, char *nz,
											char *tex, RtFloat fov,
											RtFilterFunc filterfunc,
											RtFloat swidth, RtFloat twidth,
											...);
	extern RtVoid RiMakeCubeFaceEnvironmentV(char *px, char *nx, char *py,
											 char *ny, char *pz, char *nz,
											 char *tex, RtFloat fov,
											 RtFilterFunc filterfunc,
											 RtFloat swidth,
											 RtFloat twidth, RtInt n,
											 RtToken tokens[],
											 RtPointer params[]);
	extern RtVoid RiMakeShadow(char *pic, char *tex, ...);
	extern RtVoid RiMakeShadowV(char *pic, char *tex,
								RtInt n, RtToken tokens[],
								RtPointer params[]);

	extern RtVoid RiErrorHandler(RtFunc handler);
	extern RtVoid RiErrorIgnore(RtInt code, RtInt severity, char *msg);
	extern RtVoid RiErrorPrint(RtInt code, RtInt severity, char *msg);
	extern RtVoid RiErrorAbort(RtInt code, RtInt severity, char *msg);
	extern RtVoid RiColorSamples(RtInt N, RtFloat * nRGB, RtFloat * RGBn);
	extern RtVoid RiAtmosphere(RtToken name, ...);
	extern RtVoid RiAtmosphereV(RtToken name, RtInt n, RtToken tokens[],
								RtPointer parms[]);
	extern RtVoid RiInterior(RtToken name, ...);
	extern RtVoid RiInteriorV(RtToken name, RtInt n, RtToken tokens[],
							  RtPointer parms[]);
	extern RtVoid RiExterior(RtToken name, ...);
	extern RtVoid RiExteriorV(RtToken name, RtInt n, RtToken tokens[],
							  RtPointer parms[]);

	extern RtVoid RiArchiveRecord(RtToken type, char *format, ...);

#ifdef __cplusplus
}
#endif							/* C++ */
#endif							/* RI_H */
