
#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"

class Integrator {
  public:

	virtual ~ Integrator();

	virtual Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
							   Float * hitDist, Float * alpha) const = 0;

};

class ColorIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RayCastingIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class WhittedIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
};

class MCIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
			   Float * hitDist, Float * alpha) const;

	// new function for integrating the reflected radiance due to
	// subsurface scattering
	
	Float IntegrateSS(const Ray & ray, Float w,
			  Point surface_p, Vector norm,
			  const Ray &outer_ray) const;
	
	static int RayDepth;
};

class RendermanIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
  private:
	 mutable StringHashTable shaders;
};

#endif // TRANSPORT_H
