#include "mbdofcamera.h"
#include "geometry.h"
#include "lrt.h"
#include "scene.h"
#include "image.h"
#include <iostream.h>
#include <math.h>

Float min(Float N1,Float N2)
{
  if(N1 > N2)
    return N2;
  return N1;
}

Float abs(Float N)
{
  if(N < 0)
    return -1*N;
  return N;
}

bool MbDOFCamera::GenerateRay(Float sample[5], Ray & ray) const
{
  if (sample[0] < scene->image->SampleCropLeft ||
      sample[0] > scene->image->SampleCropRight ||
      sample[1] < scene->image->SampleCropBottom ||
      sample[1] > scene->image->SampleCropTop) return false;

	Point Pcamera,AperturePoint,FocalPlanePoint;

	/* lets get some general variables */
	float t = GetTime(sample[0],sample[1],sample[4]);
	float f = FocalDistance;

	switch (ProjectionType) {
	case Camera::Orthographic:
	  /* its pointless to make a camera model for an orthograpic
	     projection, since there well is no camera.... */
	  Pcamera = RasterToCamera(Point(sample[0], sample[1], 0));
	  ray = Ray(Pcamera, Vector(0, 0, 1));
	  t = 0;
	  break;
	case Camera::Perspective:
	  Pcamera = RasterToCamera(Point(sample[0], sample[1], 0));

		//finding x & y range
	  Point Xtreme = RasterToCamera(Point(scene->image->SampleCropLeft,scene->image->SampleCropTop, 0));
	  Point Xtreme2 = RasterToCamera(Point(scene->image->SampleCropRight,scene->image->SampleCropBottom,0));

		//radius is the lesser of the two
	  Float Rad = min(min(abs(Xtreme2.x),abs(Xtreme.x)),min(abs(Xtreme2.y),abs(Xtreme.y)));

		//if it's not circle exit
	  if(Pcamera.x*Pcamera.x + Pcamera.y*Pcamera.y > Rad*Rad)
	    return false;

		//fisheye vector
	  Vector Drct = Vector(Pcamera.x,Pcamera.y,sqrt(Rad*Rad - Pcamera.x*Pcamera.x - Pcamera.y*Pcamera.y));

	  ray =	Ray(Point(0,0,Pcamera.z),Drct);
	  ray.D *= invClipHither;
	  break;
	}
	ray = CameraToWorld[0] (ray);
	return true;

	/* Now implementing motion blur */
	Ray ray1,ray2;
	ray1 = CameraToWorld[0] (ray);
	ray2 = CameraToWorld[1] (ray);


	/* Since the transformation is linnear, we have been promised a linnear
	   motion, this is the result at time t = sample[4]
	   ray = t*ray2 + (1-t)*ray1;
	   since thats illegal we have */

	ray.O = Point(t*ray2.O.x + (1-t)*ray1.O.x,
		      t*ray2.O.y + (1-t)*ray1.O.y,
		      t*ray2.O.z + (1-t)*ray1.O.z);
	ray.D = t*ray2.D + (1-t)*ray1.D;

	/* Now ending motion blur*/
	return true;
}

float
MbDOFCamera::GetTime(Float u,Float v,Float Sample) const
{
  if(ShutterType != LRT_STRIPE)
    return Sample;

  float tmax,tmin;

  /* A stripe shutter @#$%^ Lack of switch case support...*/
  if(StripeDirection == LRT_LEFT)
    {
      /* tmin will now be the time when the left edge of the shutter hits
	 the u coord, or solving the equation

	 u = t*(-StripeWith +scene->image->SampleCropLeft) + (1-t)*
	 (scene->image->SampleCropRight);

	 with respect to t gives

	 tmin = t = (u - scene->image->SampleCropRight)/(
	 scene->image->SampleCropLeft - StripeWidth -
	    scene->image->SampleCropRight)

	 We then do the same for tmax... but now we are using the right
	 barrier of our window...
      */
      tmin = (-u + scene->image->SampleCropRight)/(
	   - scene->image->SampleCropLeft +StripeWidth  +
	   scene->image->SampleCropRight);

      tmax = (scene->image->SampleCropRight + StripeWidth - u)/(
           -scene->image->SampleCropLeft + scene->image->SampleCropRight 
           + StripeWidth );
    }
  if(StripeDirection == LRT_RIGHT)
    {
      tmin = (u - scene->image->SampleCropLeft)/(
	   -scene->image->SampleCropLeft + StripeWidth +
	   scene->image->SampleCropRight);

      tmax = (scene->image->SampleCropLeft + StripeWidth - u)/(
           -scene->image->SampleCropLeft + scene->image->SampleCropRight 
           + StripeWidth );
    }
  if(StripeDirection == LRT_UP)
    {
      tmin = (v - scene->image->SampleCropBottom)/(
	   -scene->image->SampleCropBottom + StripeWidth +
	   scene->image->SampleCropTop);

      tmax = (scene->image->SampleCropBottom + StripeWidth - v)/(
           -scene->image->SampleCropBottom + scene->image->SampleCropTop 
           + StripeWidth );
    }

  if(StripeDirection == LRT_DOWN)
    {
      tmin = (-v + scene->image->SampleCropTop)/(
	   -scene->image->SampleCropBottom + StripeWidth +
	   scene->image->SampleCropTop);

      tmax = (scene->image->SampleCropTop + StripeWidth - v)/(
	   -scene->image->SampleCropBottom + StripeWidth +
	   scene->image->SampleCropTop);
    }

  return Sample*(tmax-tmin) + tmin;
}


Point 
MbDOFCamera::GetAperture(Float t,float xr,float yr) const
{
  float xa,ya;

  /* Lets find out what kind of a shutter we will be using, since 
     the Iris might change the aperture with
   */
  float a =  FocalLength/FStop;
  /* a check for that - parameter in Depth of filed sub in with 
     higher numbs */
  if(FStop >= 1E20)
    a = 0;
  if((ShutterType == LRT_IRIS) && IrisRate!=0)
    {
      /* Now we have a timed shutter, so we might need to "adjust" the
	 aperture */
      if(t < 1/IrisRate)
	{
	  /* The iris has not fully opened */
	  a = t*IrisRate*a;
	}
      if((1-1/IrisRate) < t)
	{
	  /* The iris is now closing */
	  a = (1-t)*IrisRate*a;
	}
    }
  
  /* now we need to sample the circle using shirleys mapping */
  float Theta = M_PI*yr/(4.0*xr); 
  xa = a*xr*cos(Theta);
  ya = a*xr*sin(Theta);

  return Point(xa,ya,0);
}
