
#ifndef CAMERA_H
#define CAMERA_H
#include "lrt.h"
#include "color.h"
#include "sampling.h"
#include "geometry.h"
#include "transform.h"

class Camera {
  public:
	Camera();
	virtual ~ Camera() {
	} virtual void FinalizeOptions();

	virtual bool GenerateRay(Float sample[5], Ray & ray) const = 0;

	RtToken ShutterType;
	Float IrisRate;
	Float StripeWidth;
	RtToken StripeDirection;

	Float ScreenLeft, ScreenRight, ScreenBottom, ScreenTop;

	Float ClipHither, ClipYon;

	Transform WorldToCamera[2];
	Transform CameraToScreen;
	enum { Orthographic, Perspective } ProjectionType;

	Float invClipHither;

	Transform CameraToWorld[2];
	Transform ScreenToCamera;
	Transform ScreenToRaster, RasterToScreen;
	Transform RasterToCamera;
	Transform WorldToScreen;

	Float ShutterStart, ShutterEnd;

	Float FStop, FocalLength, FocalDistance;

};

class PinholeCamera:public Camera {
  public:

	bool GenerateRay(Float sample[5], Ray & ray) const;

};

#endif // CAMERA_H
