// RedrawThread.cpp : implementation file
//

#include "stdafx.h"
#include "LFView.h"
#include "RedrawThread.h"
#include "LightField.h"
#include <math.h>
#include <GL/gl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRedrawThread

IMPLEMENT_DYNCREATE(CRedrawThread, CWinThread)

CRedrawThread::CRedrawThread()
{
	shutdown = false;
	drawWindow = NULL;
	lightField = NULL;
	drawDC = NULL;
}

CRedrawThread::~CRedrawThread()
{
}

BOOL CRedrawThread::InitInstance()
{
    hrc = wglCreateContext (drawDC);
    wglMakeCurrent (drawDC, hrc);

	return TRUE;
}

int CRedrawThread::ExitInstance()
{
	wglMakeCurrent(NULL, NULL);
	wglDeleteContext(hrc);
	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CRedrawThread, CWinThread)
	//{{AFX_MSG_MAP(CRedrawThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRedrawThread message handlers

int CRedrawThread::Run() 
{
	float oldFStop = 0, oldFocalDistance = 0;
	int oldInterpolate = 0, oldDOF = 0;
	float oldTranslateX = 0, oldTranslateY = 0;
	bool firstTime = true;

	CRect rect;

	CStatic *paintArea = (CStatic*)drawWindow->GetDlgItem(IDC_PAINT);
	paintArea->GetClientRect(&rect);

	int width = rect.Width(), height = rect.Height();
	int maxSamples = width * height;

	int *outTotals = new int[maxSamples * 3];
	int *outWeights = new int[maxSamples];
	Spectrum *outBitmap = new Spectrum[maxSamples];
	Spectrum temp;

	int sample;

	while(!shutdown)
	{
		CSliderCtrl *slider = (CSliderCtrl*)drawWindow->GetDlgItem(IDC_DOF);
		float fStop = (float)slider->GetPos();
		slider = (CSliderCtrl*)drawWindow->GetDlgItem(IDC_FOCAL_DISTANCE);
		float focalDistance = float(pow(2.0, float(slider->GetPos() - 5) / 5.0));
		slider = (CSliderCtrl*)drawWindow->GetDlgItem(IDC_TRANSLATE_X);
		float translateX = (slider->GetPos() - 50.f) / 101.f;
		slider = (CSliderCtrl*)drawWindow->GetDlgItem(IDC_TRANSLATE_Y);
		float translateY = (slider->GetPos() - 50.f) / 101.f;

		CButton *checkBox = (CButton*)drawWindow->GetDlgItem(IDC_INTERPOLATE_ENABLE);
		int interpolate = checkBox->GetCheck();
		checkBox = (CButton*)drawWindow->GetDlgItem(IDC_DOF_ENABLE);
		int dof = checkBox->GetCheck();

		if(firstTime || fStop != oldFStop || focalDistance != oldFocalDistance ||
			oldTranslateX != translateX || oldTranslateY != translateY ||
			oldInterpolate != interpolate || oldDOF != dof)
		{
			memset(outWeights, 0, maxSamples * sizeof(int));
			memset(outTotals, 0, maxSamples * 3 * sizeof(int));
			firstTime = false;
			oldFStop = fStop;
			oldFocalDistance = focalDistance;
			oldInterpolate = interpolate;
			oldDOF = dof;
			oldTranslateX = translateX;
			oldTranslateY = translateY;
		}
		
		sample = 0;
		
		for(int y = 0; y < height; y++)
		{
			for(int x = 0; x < width; x++)
			{
				if(lightField->DoDOF((float)x / width, (float)y / height, -translateX, translateY,
					fStop * lightField->header.MinFStop, focalDistance * lightField->header.DefaultFocalDistance,
					interpolate, dof, temp))
				{
					outTotals[sample * 3] += temp.color[0];
					outTotals[sample * 3 + 1] += temp.color[1];
					outTotals[sample * 3 + 2] += temp.color[2];
					outWeights[sample]++;
				}
				if(outWeights[sample] > 0)
				{
					outBitmap[sample].color[0] = outTotals[sample * 3] / outWeights[sample];
					outBitmap[sample].color[1] = outTotals[sample * 3 + 1] / outWeights[sample];
					outBitmap[sample].color[2] = outTotals[sample * 3 + 2] / outWeights[sample];
				}
				else
				{
					outBitmap[sample].color[0] = 127;
					outBitmap[sample].color[1] = 127;
					outBitmap[sample].color[2] = 127;
				}
				sample++;
			}
		}
		
		glDrawPixels(width, height, GL_RGB, GL_UNSIGNED_BYTE, outBitmap);
		
		SwapBuffers(drawDC);
	}

	delete outTotals;
	delete outWeights;
	delete outBitmap;

	return FALSE;
}