// LightField.h: interface for the LightField class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LIGHTFIELD_H__0077AAA0_3B24_4C03_A4E1_2289983A0570__INCLUDED_)
#define AFX_LIGHTFIELD_H__0077AAA0_3B24_4C03_A4E1_2289983A0570__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef struct
{
	unsigned char color[3];
} Spectrum;

typedef struct
{
	int XWidth, YWidth;
	int PixelSamples[2];
	float FocalLength;
	float ZFilmPlane;
	float DefaultFocalDistance;
	float MinFStop;
	float xSpan, ySpan;
} LightFieldHeader;

class LightField  
{
public:
	LightField(CString filename);
	virtual ~LightField();

	bool DoDOF(float xRaster, float yRaster, float xEye, float yEye,
		float fStop, float focalDistance, 
		int interpolate, int dof, Spectrum &color);

	LightFieldHeader header;

protected:
	bool Interpolate(float xRaster, float yRaster, float xEye, float yEye,
		int interpolate, Spectrum &color);
	void GenerateRandomPoint(float sample[2], float maxRadius, float &x, float &y);
	void Bilerp(Spectrum *samples, float wx, float wy, Spectrum &color);
	bool Lookup(int xRaster, int yRaster, int xEye, int yEye, Spectrum &color);

	int numSamples;
	Spectrum *samples;
};

#endif // !defined(AFX_LIGHTFIELD_H__0077AAA0_3B24_4C03_A4E1_2289983A0570__INCLUDED_)
