// LFViewDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LFView.h"
#include "LFViewDlg.h"
#include "LightField.h"
#include "RedrawThread.h"
#include <math.h>
#include <Gl/gl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLFViewDlg dialog

CLFViewDlg::CLFViewDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLFViewDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLFViewDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CLFViewDlg::~CLFViewDlg()
{
	delete lightField;
}

void CLFViewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLFViewDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLFViewDlg, CDialog)
	//{{AFX_MSG_MAP(CLFViewDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLFViewDlg message handlers

BOOL CLFViewDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	lightField = new LightField(m_filename);
	
	CWnd *paintArea = GetDlgItem(IDC_PAINT);
	
	dc = ::GetDC(paintArea->m_hWnd);
	SetDCPixelFormat(m_hWnd,dc);
	
	CButton *checkBox = (CButton*)GetDlgItem(IDC_DOF_ENABLE);
	checkBox->SetCheck(true);
	checkBox = (CButton*)GetDlgItem(IDC_INTERPOLATE_ENABLE);
	checkBox->SetCheck(true);
	CSliderCtrl *slider = (CSliderCtrl*)GetDlgItem(IDC_DOF);
	slider->SetRange(1, 10);
	slider->SetPos(1);
	slider = (CSliderCtrl*)GetDlgItem(IDC_FOCAL_DISTANCE);
	slider->SetRange(0, 10);
	slider->SetPos(5);
	slider = (CSliderCtrl*)GetDlgItem(IDC_TRANSLATE_X);
	slider->SetRange(0, 100);
	slider->SetPos(50);
	slider->SetTicFreq(10);
	slider = (CSliderCtrl*)GetDlgItem(IDC_TRANSLATE_Y);
	slider->SetRange(0, 100);
	slider->SetPos(50);
	slider->SetTicFreq(10);

	m_RedrawThread = new CRedrawThread();

	m_RedrawThread->m_bAutoDelete = true;
	m_RedrawThread->drawDC = dc;
	m_RedrawThread->drawWindow = this;
	m_RedrawThread->lightField = lightField;

	if(m_RedrawThread->CreateThread() == FALSE)
	{
		delete m_RedrawThread;
		m_RedrawThread = NULL;
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLFViewDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CLFViewDlg::SetDCPixelFormat (HWND hwnd,HDC hdc)
{
    HANDLE hHeap;
    int nColors, i;
    LPLOGPALETTE lpPalette;
    BYTE byRedMask, byGreenMask, byBlueMask;
	HPALETTE hPalette;

    static PIXELFORMATDESCRIPTOR pfd = {
        sizeof (PIXELFORMATDESCRIPTOR),             // Size of this structure
        1,                                          // Version number
        PFD_DRAW_TO_WINDOW |                        // Flags
        PFD_SUPPORT_OPENGL |
        PFD_GENERIC_ACCELERATED|
        PFD_DOUBLEBUFFER,
        PFD_TYPE_RGBA,                              // RGBA pixel values
        32,                                         // 24-bit color
        0, 0, 0, 0, 0, 0,                           // Don't care about these
        0, 0,                                       // No alpha buffer
        0, 0, 0, 0, 0,                              // No accumulation buffer
        32,                                         // 32-bit depth buffer
        0,                                          // No stencil buffer
        0,                                          // No auxiliary buffers
        PFD_MAIN_PLANE,                             // Layer type
        0,                                          // Reserved (must be 0)
        0, 0, 0                                     // No layer masks
    };

    int nPixelFormat;

    nPixelFormat = ChoosePixelFormat (hdc, &pfd);
    SetPixelFormat (hdc, nPixelFormat, &pfd);

    if (pfd.dwFlags & PFD_NEED_PALETTE) {
        nColors = 1 << pfd.cColorBits;
        hHeap = GetProcessHeap ();

        (LPLOGPALETTE) lpPalette = (LPLOGPALETTE)HeapAlloc (hHeap, 0,
            sizeof (LOGPALETTE) + (nColors * sizeof (PALETTEENTRY)));

        lpPalette->palVersion = 0x300;
        lpPalette->palNumEntries = nColors;

        byRedMask = (1 << pfd.cRedBits) - 1;
        byGreenMask = (1 << pfd.cGreenBits) - 1;
        byBlueMask = (1 << pfd.cBlueBits) - 1;

        for (i=0; i<nColors; i++) {
            lpPalette->palPalEntry[i].peRed =
                (((i >> pfd.cRedShift) & byRedMask) * 255) / byRedMask;
            lpPalette->palPalEntry[i].peGreen =
                (((i >> pfd.cGreenShift) & byGreenMask) * 255) / byGreenMask;
            lpPalette->palPalEntry[i].peBlue =
                (((i >> pfd.cBlueShift) & byBlueMask) * 255) / byBlueMask;
            lpPalette->palPalEntry[i].peFlags = 0;
        }

        hPalette = CreatePalette (lpPalette);
        HeapFree (hHeap, 0, lpPalette);

        if (hPalette != NULL) {
            SelectPalette (hdc, hPalette, FALSE);
            RealizePalette (hdc);
        }
    }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CLFViewDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CLFViewDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int CLFViewDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}

void CLFViewDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	::ReleaseDC(m_hWnd, dc);
	
}

BOOL CLFViewDlg::DestroyWindow() 
{
	if(m_RedrawThread)
		m_RedrawThread->shutdown = true;

	::WaitForSingleObject(m_RedrawThread->m_hThread, INFINITE);
	
	return CDialog::DestroyWindow();
}
