
#ifndef TEXTURE_H
#define TEXTURE_H
#include "lrt.h"

class MIPMap {
  public:

	MIPMap(const char *filename);

	int XResolution() const {
		return xResolution;
	} int YResolution() const {
		return yResolution;
	} Spectrum GetTexel(int x, int y, int level) const;

  private:
	 u_char * data;
	int xResolution, yResolution;

};

class TextureMap { public:
	 TextureMap(const char *filename);

	~TextureMap();

	Spectrum Lookup(Float u, Float v) const;

	Spectrum Lookup(Float u, Float v, Float width) const;

	Spectrum Lookup(Float u, Float v, Float dudx, Float dudy,
					Float dvdx, Float dvdy) const;
	int GetRealWidth() const {return width;}
	int GetRealHeight() const {return height;}					
	Spectrum LookupNBL(Float u, Float v) const;

  private:
	 Spectrum * Texture;
	int width, height;

};

#endif // TEXTURE_H
