
#ifndef SCENE_H
#define SCENE_H

class Scene {
  public:

	Scene();

	void AddPrimitives(const vector < Primitive * >&prim);

	virtual void Render();

	virtual ~Scene();

	bool Intersect(const Ray & ray, Float mint, Float * maxt,
				   HitInfo * hit) const;

	bool Unoccluded(const Point &, const Point &) const;
	bool Unoccluded(const Ray &) const;

	Camera *camera;
	Image *image;
	JitterSampler *sampler;

	RtToken IlluminationIntegrator;

  private:
	 Accelerator * accelerator;
	 vector < Primitive * >primitives;

};

#ifdef USE_MPI
class MPIScene : public Scene {
public:
        MPIScene();
	virtual ~MPIScene();
	virtual void Render();
};
#endif

#endif // SCENE_H
