
#ifndef SAMPLING_H
#define SAMPLING_H
#include "lrt.h"

#define SQRT_SAMPLE_TABLE_SIZE 32
#define SAMPLE_TABLE_SIZE (SQRT_SAMPLE_TABLE_SIZE * SQRT_SAMPLE_TABLE_SIZE)

class Sampler {
  public:
	Sampler();
	virtual ~ Sampler() {
	} virtual void FinalizeValues() {
	} virtual bool GetNextImageSample(Float sample[5]) = 0;
	virtual int GetNumSamples() = 0;
	virtual void SkipSamples(int numToSkip) = 0;

	Float PixelSamples[2];
	Float LightFieldSamples[2];

	bool JitterSamples;

	RtFilterFunc Filter;

	Float FilterXWidth, FilterYWidth;

};

class JitterSampler:public Sampler { public:
	 JitterSampler();

	virtual void FinalizeValues();

	virtual bool GetNextImageSample(Float sample[5]);
	virtual bool AdvanceSample();
	virtual int GetNumSamples();
	virtual void SkipSamples(int numToSkip);

  protected:
	 int XMax, YMax;
	Float DeltaX, DeltaY;

	int XPos, YPos;

};

class LightFieldSampler:public JitterSampler {
public:
	LightFieldSampler();
	
	virtual void FinalizeValues();
	
	virtual bool AdvanceSample();
	virtual bool GetNextImageSample(Float sample[5]);
	virtual int GetNumSamples();
	
protected:
	int EyeXMax, EyeYMax;
	Float DeltaEyeX, DeltaEyeY;
	
	int EyeXPos, EyeYPos;
	
};

class GeneralSampler:public Sampler { public:
	 GeneralSampler();

	bool GetNextImageSample(Float sample[5]);
	virtual int GetNumSamples();
	virtual void SkipSamples(int numToSkip);

  private:
	 static const Float sampleTable[SAMPLE_TABLE_SIZE][5];
	int tablePos;
	Float x0, y0;
	Float DeltaX, DeltaY;

};

extern Float BoxFilter(Float x, Float y, Float xwidth, Float ywidth);

extern Float TriangleFilter(Float x, Float y, Float xwidth, Float ywidth);

extern Float GaussianFilter(Float x, Float y, Float xwidth, Float ywidth);

extern Float MitchellFilter(Float x, Float y, Float xwidth, Float ywidth);

#endif // SAMPLING_H
