
#include "lrt.h"

#ifdef USE_MPI
#include <mpi.h>
#endif

int main(int argc, char *argv[])
{
#ifdef USE_MPI
	MPI_Init(&argc, &argv);
#endif

	fprintf(stderr, "lrt version %1.3f of %s at %s\n", LRT_VERSION,
			__DATE__, __TIME__);

	if (getenv("LRT_YYDEBUG") != NULL)
		ParseEnableDebug();

	RiBegin(RI_NULL);

	if (argc == 1) {

		ParseRIB("-");

	} else {

		for (int i = 1; i < argc; i++) {
			if (!ParseRIB(argv[i]))
				Error("Couldn't open %s\n", argv[i]);
		}

	}

	RiEnd();
	
#ifdef USE_MPI
	MPI_Finalize();
#endif
	
	return 0;
}
