
#ifndef IRIDESCENT_H
#define IRIDESCENT_H
#include "lrt.h"
#include "primitives.h"

class IridescentSurface:public Material {
public:
	IridescentSurface(SurfaceFunction * data)
	: Material(data) {
		Ks = surfaceFunction->InitializeFloat(RI_KS, .5);
		Kd = surfaceFunction->InitializeFloat(RI_KD, .5);
		Roughness = surfaceFunction->InitializeFloat(RI_ROUGHNESS, .1);
		SpecularColor =
			surfaceFunction->InitializeColor(RI_SPECULARCOLOR,
							 Spectrum(1.));
	
		ic[0] =surfaceFunction->InitializeColor(LRT_IRIDESCENT_COLOR1,
					 				Spectrum(1.));
		ic[1] = surfaceFunction->InitializeColor(LRT_IRIDESCENT_COLOR2,
									Spectrum(1.));
		Cs = surfaceFunction->InitializeColor(LRT_IRIDESCENT_DIFFUSECOLOR,
							(ic[0] + ic[1]) / 2.0 / 1.25);
		
		sFrequency = surfaceFunction->InitializeFloat(LRT_IRIDESCENT_SFREQ, 1.);
		tFrequency = surfaceFunction->InitializeFloat(LRT_IRIDESCENT_TFREQ, 1.);
		
		maxAlpha = surfaceFunction->InitializeFloat(LRT_IRIDESCENT_MAXALPHA, 1.);
		spotSize = surfaceFunction->InitializeFloat(LRT_IRIDESCENT_SPOTSIZE, 1.4);
	}
	
	BRDF *Shade(const ShadeContext &sc) const;
	
private:	
	Float Kd, Ks, Roughness;
	Spectrum SpecularColor, Cs;
	Float maxAlpha, spotSize;
	Spectrum ic[2];
	Float sFrequency, tFrequency;
};

class IridescentReflector:public BRDF { public:
	IridescentReflector(const Spectrum *ic, Spectrum Cs, Float maxAlpha, Float spotSize,
			Float sParam, Float tParam,
	 		const Normal &normal, const Vector &wo);

	Spectrum fr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:
	void AddIridescentSpot(Float costhetah, Float s, Float t, int xAdj, int yAdj, int offset, const Spectrum *ic, Spectrum &curColor, Float &alpha) const;
	Spectrum ic[2];
	Spectrum Cs;
	Float maxAlpha, spotSize;
	Float sParam, tParam;
	Vector wo;
	Normal N;
	Float costhetao;
};

#endif