
#include "shading.h"
#include "color.h"
#include "reflection.h"
#include "texture.h"
#include "iridescent.h"

BRDF *CreateIridescent(const Spectrum *ic, Spectrum Cs, Float maxAlpha, Float spotSize,
			Float sParam, Float tParam,
	 		const Normal &normal, const Vector &wo)
{
	return new IridescentReflector(ic, Cs, maxAlpha, spotSize, sParam, tParam, normal, wo);
}

BRDF *IridescentSurface::Shade(const ShadeContext & sc) const
{
	Float surfKd = sc.InitializeFloat(RI_KD, Kd);
	Float surfKs = sc.InitializeFloat(RI_KS, Ks);
	Float surfRoughness = sc.InitializeFloat(RI_ROUGHNESS, Roughness);
	Spectrum surfSpecColor =
		sc.InitializeColor(RI_SPECULARCOLOR, SpecularColor);
	
	Spectrum surfaceIC[2];
	surfaceIC[0] = sc.InitializeColor(LRT_IRIDESCENT_COLOR1, ic[0]);
	surfaceIC[1] = sc.InitializeColor(LRT_IRIDESCENT_COLOR2, ic[1]);
	Spectrum surfColor = sc.InitializeColor(LRT_IRIDESCENT_DIFFUSECOLOR, Cs);
	
	Float surfaceSFrequency = sc.InitializeFloat(LRT_IRIDESCENT_SFREQ, sFrequency);
	Float surfaceTFrequency = sc.InitializeFloat(LRT_IRIDESCENT_TFREQ, tFrequency);
	
	Float s = sc.InitializeFloat(RI_S, 0.);
	Float t = sc.InitializeFloat(RI_T, 0.);
	
	Float surfMaxAlpha = sc.InitializeFloat(LRT_IRIDESCENT_MAXALPHA, maxAlpha);
	Float surfSpotSize = sc.InitializeFloat(LRT_IRIDESCENT_SPOTSIZE, spotSize);
	
	ScatteringMixture *mix = CreateScatteringMixture();
	
	mix->AddFunction(CreateIridescent(surfaceIC,  surfKd * surfColor, surfMaxAlpha,
						surfSpotSize, s * surfaceSFrequency,
						t * surfaceTFrequency, sc.Ns, sc.wo));
	mix->AddFunction(CreateBlinnGlossy(surfKs * surfSpecColor,  Clamp(surfRoughness, 0., 1.), sc.Ns,  sc.wo));\
	
	return mix;
}

static long long p = 7541;
static long long q = 5039;
static long long pq = p * q;

static const int kNumTableElements = 65536;
static const long long kSeed = 1655779;

static char lookupTable[kNumTableElements];

static void GenerateTable()
{
	long long curNum = kSeed;
	char curBits;
	for( int i = 0; i < kNumTableElements; i++ )
	{
		curBits = 0;
		for( int j = 0; j < 8; j++)
		{
			curNum = curNum * curNum;
			curNum %= pq;
			curBits = (curBits << 1) + curNum % 2;
		}
		lookupTable[i] = curBits;
	}
}

static int GenerateRandomNumber(int wordStart, int numBits)
{
	static bool tableGenerated = false;
	
	if (!tableGenerated)
	{
		GenerateTable();
		tableGenerated = true;
	}
	
	wordStart %= kNumTableElements;
	
	return lookupTable[wordStart] & ((1 << numBits) - 1);
}

IridescentReflector::IridescentReflector(const Spectrum *ic, Spectrum Cs, Float maxAlpha, Float spotSize,
			Float sParam, Float tParam,
	 		const Normal &normal, const Vector &wo)
{
	N = normal;
	this->wo = wo;
	costhetao = Dot(wo, N);
	this->sParam = sParam;
	this->tParam = tParam;
	this->maxAlpha = maxAlpha;
	this->spotSize = spotSize;
	this->ic[0] = ic[0];
	this->ic[1] = ic[1];
	this->Cs = Cs;
}

static const int sVar = 9973;
static const int tVar = 5417;

void IridescentReflector::AddIridescentSpot(Float costhetah, Float s, Float t, int xAdj, int yAdj, int offset, const Spectrum *ic, Spectrum &curColor, Float &alpha) const
{
	int sLookup = (int)(s + xAdj + 17) * sVar;
	int tLookup = (int)(t + yAdj + 17) * tVar;
	
	int startLookup = sLookup + tLookup + offset;
	
	bool exists = GenerateRandomNumber(startLookup, 4) < 12;
	if(exists) {
		Float ds = s - floor(s) - 0.5 - xAdj;
		Float dt = t - floor(t) - 0.5 - yAdj;
		
		Float rSpotPos = (GenerateRandomNumber(startLookup + 2, 4) - 8) / 16.;
		Float tSpotPos = (GenerateRandomNumber(startLookup + 3, 4) / .16 * 2. - costhetah) * M_PI;
		
		Float xSpotPos = rSpotPos * cos(tSpotPos);
		Float ySpotPos = rSpotPos * sin(tSpotPos);
		
		Float dx = fabs(xSpotPos - ds) * 2.;
		Float dy = fabs(ySpotPos - dt) * 2.;
		
		Float maxValue = max(dx, dy);
		Float medValue = min(dx, dy);
	
		Float distanceToSpot = maxValue + 5. / 16. * medValue;
	
		if(distanceToSpot <= spotSize)
		{
			Float attenuation = (cos(distanceToSpot * M_PI / spotSize) + 1.) / 2. * maxAlpha;
			Float colorRotation = GenerateRandomNumber(startLookup + 5, 4) / 16. * M_PI;
			Float colorBlend = (cos(2 * (atan2(dt , ds) + colorRotation + costhetah * (distanceToSpot / spotSize + 1.) * M_PI / 2.)) + 1.) / 2.;
			Spectrum outColor = ic[0] + (ic[1] - ic[0]) * colorBlend;
			curColor += outColor * attenuation;
			alpha += attenuation;
			return;
		}
	}
}

Spectrum IridescentReflector::fr(const Vector &wi) const
{
	Vector H = (wi + wo).Hat();
	Float costhetah = Dot(N, H);
	Float costhetai = Dot(N, wi);
	
	if(costhetai < 0.)
		return Spectrum(0.);
	
	Spectrum curColor = Spectrum(0.);
	Float alpha = 0.;
	
	for(int x = -1; x <= 1; x++)
	{
		for(int y = -1; y <= 1; y++)
		{
			AddIridescentSpot(costhetah, sParam, tParam, x, y, 0, ic, curColor, alpha);
			AddIridescentSpot(costhetah, sParam, tParam, x, y, 12573, ic, curColor, alpha);
		}
	}
	
	alpha = Clamp (alpha, 0., 1.);
	
	return Cs * (1. - alpha) + curColor;
}

Spectrum IridescentReflector::Sample(Float u[2], Vector * wi, Float * pdf) const
{
	return Spectrum(0.);
}

Float IridescentReflector::Pdf(const Vector & wi) const
{
	return 0.;
}

