
#ifndef IMAGE_H
#define IMAGE_H
#include "lrt.h"
#include "color.h"

class Image {
  public:

	Image();

	virtual void FinalizeValues();

	virtual ~Image();

	virtual void AddSampleBasic(const Point & PRaster, const Spectrum & radiance,
						Float alpha);

	virtual void Write() const;

	virtual void AddSample(const Point & PRaster, const Spectrum & radiance,
				   Float alpha);

	int XResolution, YResolution;

	Float CropLeft, CropRight, CropBottom, CropTop;

	RtToken DisplayMode;

	Float Gain, Gamma;

	RtToken Imager;

	int ColorQuantOne, ColorQuantMin, ColorQuantMax;
	Float ColorQuantDither;

	int DepthQuantOne, DepthQuantMin, DepthQuantMax;
	Float DepthQuantDither;

	RtToken DisplayType, DisplayName;

	char *ImageViewer;

	Float SampleCropLeft, SampleCropRight;
	Float SampleCropTop, SampleCropBottom;

	Float PixelAspectRatio, FrameAspectRatio;

protected:
	 static void scaleAndDither(Float one, Float min, Float max, Float dither,
								Float * pixels, int nPixels);

	int XBase, YBase, XWidth, YWidth;

	Spectrum *Pixels;
	Float *Alphas, *Depths;
	Float *WeightSums;

};

class LightFieldImage : public Image
{
public:
	LightFieldImage();
	
	virtual void FinalizeValues();
	virtual void Write() const;

	virtual void AddLightFieldSample(const Point & Praster, const Point &eyeJitter,
					const Spectrum & radiance, Float alpha);
					
protected:
	int LightFieldSamples[2];
	Spectrum *LightField;
	
	int CalculateOffset(const Point &Praster, const Point &eyeJitter);
};

#endif // IMAGE_H
