
#ifndef COLOR_H
#define COLOR_H
#include "lrt.h"
#include <iostream.h>

class Spectrum {
  public:

	Spectrum() {
		s[0] = s[1] = s[2] = 0.;
	} Spectrum(Float i) {
		s[0] = s[1] = s[2] = i;
	}
	Spectrum(Float r, Float g, Float b) {
		s[0] = r;
		s[1] = g;
		s[2] = b;
	}

	friend ostream & operator << (ostream &, const Spectrum &);

	Spectrum & operator += (const Spectrum & s2) {
		s[0] += s2.s[0];
		s[1] += s2.s[1];
		s[2] += s2.s[2];
		return *this;
	}
	Spectrum operator + (const Spectrum & s2) const {
		return Spectrum(s[0] + s2.s[0], s[1] + s2.s[1], s[2] + s2.s[2]);
	} Spectrum operator - (const Spectrum & s2) const {
		return Spectrum(s[0] - s2.s[0], s[1] - s2.s[1], s[2] - s2.s[2]);
	} Spectrum operator *(const Spectrum & s2) const {
		return Spectrum(s[0] * s2.s[0], s[1] * s2.s[1], s[2] * s2.s[2]);
	} Spectrum operator / (const Spectrum & s2) const {
		return Spectrum(s[0] / s2.s[0], s[1] / s2.s[1], s[2] / s2.s[2]);
	}
	Spectrum & operator *= (const Spectrum & sp) {
		s[0] *= sp.s[0];
		s[1] *= sp.s[1];
		s[2] *= sp.s[2];
		return *this;
	}
	float GetRed(void ) const {return s[0];}
	float GetGreen(void ) const {return s[1];}
	float GetBlue(void ) const {return s[2];}
//	float GetIntensity(void) const {return

		

	Spectrum operator *(Float a) const {
		return Spectrum(s[0] * a, s[1] * a, s[2] * a);
	} Spectrum & operator *= (Float a) {
		s[0] *= a;
		s[1] *= a;
		s[2] *= a;
		return *this;
	}
	friend inline Spectrum operator *(Float a, const Spectrum & s) {
		return Spectrum(s.s[0] * a, s.s[1] * a, s.s[2] * a);
	} Spectrum operator / (Float a) const { Float inv = 1. / a;
		 return Spectrum(s[0] * inv, s[1] * inv, s[2] * inv);
	} Spectrum & operator /= (Float a) {
		Float inv = 1. / a;
		s[0] *= inv;
		s[1] *= inv;
		s[2] *= inv;
		return *this;
	}

	bool operator == (const Spectrum & sp) const {
		return (s[0] == sp.s[0] && s[1] == sp.s[1] && s[2] == sp.s[2]);
	}
		Spectrum Pow(const Spectrum & s2) const {
			  return Spectrum(pow(max((Float) 0., s[0]), s2.s[0]),
							  pow(max((Float) 0., s[1]), s2.s[1]),
							  pow(max((Float) 0., s[2]), s2.s[2]));
	} void ConvertToRGB(Float * result) const;

	friend class SLTriple;

  private:

	Float s[3];

};

#endif // COLOR_H
