
#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"
#include "photonmap.h"

class Integrator {
  public:

	virtual ~ Integrator();

	virtual Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
							   Float * hitDist, Float * alpha) const = 0;

	void Initialize() {
	  GmapN = NULL;
	  CmapN = NULL;
	  ImapN = NULL;
	  GmaxNphotons = 0;
	  CmaxNphotons = 0;
	  ImaxNphotons = 0;
	}

	void SetupPhotonMap(PhotonMap *map, int id, int maxPhotons)
	{
	  switch (id) {
	  case 0:
	    GmapN = map;
	    GmaxNphotons = maxPhotons;
	    break;
	  case 1:
	    CmapN = map;
	    CmaxNphotons = maxPhotons;
	    break;
	  case 2:
	    ImapN = map;
	    ImaxNphotons = maxPhotons;
	    break;
	  default:
	    break;
	  }
  	  map->SetMaxN(maxPhotons);
      }

 public:
	PhotonMap *GmapN;
	PhotonMap *CmapN;
	PhotonMap *ImapN;
	int GmaxNphotons;
	int CmaxNphotons;
	int ImaxNphotons;
};

class ColorIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class RayCastingIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
};

class WhittedIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
};

class MCIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
	static int RayDepth;
	const static int MaxRayDepth = 3;
};

class RendermanIntegrator:public Integrator { public:
	Spectrum Integrate(const Ray & ray, HitInfo * hitInfo,
					   Float * hitDist, Float * alpha) const;
  private:
	 mutable StringHashTable shaders;
};

#endif // TRANSPORT_H
