#ifndef SCENE_H
#define SCENE_H

#include "photonmap.h"

class Scene {
  public:

	Scene();

	void AddPrimitives(const vector < Primitive * >&prim);

	void Render();

	~Scene();

	bool Intersect(const Ray & ray, Float mint, Float * maxt,
				   HitInfo * hit) const;

	bool Unoccluded(const Point &, const Point &) const;
	bool Unoccluded(const Ray &) const;

	Camera *camera;
	Image *image;
	JitterSampler *sampler;

	RtToken IlluminationIntegrator;
	vector < Primitive * >primitives;

  private:
	Accelerator * accelerator;
	PhotonMap *GmapN;
	PhotonMap *CmapN;
	PhotonMap *ImapN;
};

#endif // SCENE_H
