
#include "lrt.h"
#include "primitives.h"
#include "quadrics.h"
#include "trimesh.h"

Primitive::~Primitive()
{
	delete surfaceFunction;
	attributes->Dereference();
}

BBox Primitive::BoundWorldSpace() const
{
	return attributes->ObjectToWorld(BoundObjectSpace());
}

void Primitive::Refine(vector < Primitive * >*refined) const
{
	Severe("Unimplemented Primitive::Refine() method called");
}

bool Primitive::IntersectClosest(const Ray & ray, Float mint,
								 Float * maxt, HitInfo * hit) const
{
	Severe("Unimplemented _IntersectClosest() method called");
	return false;
}

bool Primitive::IntersectAll(const Ray & ray, Float mint,
							 Float maxt, list < HitInfo * >&hits) const
{
	bool anyHit = false;
	HitInfo hitInfo;
	if (IntersectClosest(ray, mint, &maxt, &hitInfo)) {
		anyHit = true;
		hits.push_back(new HitInfo(hitInfo));
	}
	return anyHit;
}

Float Primitive::Sample(Float[2], HitInfo *) const
{
	Severe("Sample() method unimplemented for primitive");
	return 0.;
}

Float Primitive::Pdf(const Ray &, Float *, Point *) const
{
	Severe("Pdf() method unimplemented for primitive");
	return 0.;
}

Float Sphere::Sample(Float u[2], HitInfo * hitInfo) const
{
  float theta = (u[0] * 2 * M_PI);
  float phi = (u[1] * M_PI) - (M_PI * 0.5);
  float cos_phi = cosf(phi);
  
  Point P;
  P.x = cos_phi * cosf(theta) * this->radius;
  P.y = cos_phi * sinf(theta) * this->radius;
  P.z = sinf(phi) * this->radius;

  //fprintf(stderr, "Point = %f %f %f\n", P.x, P.y, P.z);

  Normal N;
  
  hitInfo->RecordHit(P, N, 0, 0, this);

  return 1.0;

}

Float Cylinder::Sample(Float u[2], HitInfo * hitInfo) const
{
	// YOUR CODE HERE: sample a point P, and compute
	// the inverse mapping to find uu and vv.  Then
	// pass this and the Disk's Normal, (0,0,1) into
	// the (misnamed) RecordHit() method of HitInfo.

	// hitInfo->RecordHit(P, N, uu,
	//                    vv, attributes, surfaceFunction);
	// return Pdf;
	return 0.;
}

Float Cone::Sample(Float u[2], HitInfo * hitInfo) const
{
	// YOUR CODE HERE: sample a point P, and compute
	// the inverse mapping to find uu and vv.  Then
	// pass this and the Disk's Normal, (0,0,1) into
	// the (misnamed) RecordHit() method of HitInfo.

	// hitInfo->RecordHit(P, N, uu,
	//                    vv, attributes, surfaceFunction);
	// return Pdf;
	return 0.;
}

Float Sphere::Pdf(const Ray & ray, Float * costhetao, Point * Plight) const
{
	// YOUR CODE HERE
	return 0.;
}

Float Cylinder::Pdf(const Ray & ray, Float * costhetao, Point * Plight) const
{
	// YOUR CODE HERE
	return 0.;
}

Float Cone::Pdf(const Ray & ray, Float * costhetao, Point * Plight) const
{
	// YOUR CODE HERE
	return 0.;
}

HitInfo::HitInfo()
{

	interpolatedData = NULL;

}

HitInfo::~HitInfo()
{

	delete interpolatedData;

}

void HitInfo::RecordHit(const Point & Po, const Normal & No,
						Float uu, Float vv, const Primitive * prim)
{
	Pobj = Po;
	NgObj = No;
	u = uu, v = vv;
	hitPrim = prim;
}

void HitInfo::SetInterpolatedData(InterpolatedPrimData * id)
{
	delete interpolatedData;
	interpolatedData = id;
}

const Point *HitInfo::GetPoint(RtToken token) const
{
	if (token == RI_P)
		return &Pobj;
	if (!interpolatedData)
		return NULL;
	return interpolatedData->GetPoint(token);
}

const Float *HitInfo::GetFloat(RtToken token) const
{
	const Float *ret = hitPrim->surfaceFunction->GetUniformFloat(token);
	if (ret)
		return ret;
	if (!interpolatedData)
		return NULL;
	return interpolatedData->GetFloat(token);
}
const Vector *HitInfo::GetVector(RtToken token) const
{
	const Vector *ret = hitPrim->surfaceFunction->GetUniformVector(token);
	if (ret)
		return ret;
	if (!interpolatedData)
		return NULL;
	return interpolatedData->GetVector(token);
}
const Normal *HitInfo::GetNormal(RtToken token) const
{
	const Normal *ret = hitPrim->surfaceFunction->GetUniformNormal(token);
	if (ret)
		return ret;
	if (!interpolatedData)
		return NULL;
	return interpolatedData->GetNormal(token);
}
const Spectrum *HitInfo::GetColor(RtToken token) const
{
	const Spectrum *ret = hitPrim->surfaceFunction->GetUniformColor(token);
	if (ret)
		return ret;
	if (!interpolatedData)
		return NULL;
	return interpolatedData->GetColor(token);
}
const char *HitInfo::GetString(RtToken token) const
{
	return hitPrim->surfaceFunction->GetUniformString(token);
}
