#ifndef PHOTONMAP_H
#define PHOTONMAP_H

#include "lrt.h"
#include "color.h"
#include "geometry.h"
#include "light.h"
#include "quadrics.h"
#include "reflection.h"
#include "scene.h"

#include <ANN/ANN.h>
#include "hash.h"

typedef enum { GlobalMap, CausticMap, IndirectMap } MapType;

typedef struct
{
  ANNpoint annPosition;

  Point position;
  Spectrum power;
  Vector incidentDirection;

  Float distance;
} Photon;

ANNpoint GetKeyFromPhoton(Photon *photon);
unsigned int HashKey(ANNpoint key);

class PhotonMap
{
 public:
  PhotonMap(Scene *scene, MapType type, int photonsPerLight,
	    vector < float > *primSpheres,
	    vector < Vector > *primSphereOffsets,
	    vector < float > *weights);
  ~PhotonMap();

  void FreeNearestPhotons(Photon **nearestPhotons);
  void GeneratePhotonMap();
  float GetClosestDistance(Point ref);
  Photon **GetNearestPhotons(Point referencePoint, int *numPhotons);
  void SetMaxN(int numPhotons);

 private:
  ANNkd_tree *photonTree;
  ANNpointArray photonArray;
  HashTable <ANNpoint, Photon *> *photonTable;
  int photonsPerLight;
  list <Light *> allLights;
  MapType type;
  Scene *scene;
  vector < float > *primSpheres;
  vector < Vector > *primSphereOffsets;
  vector < float > *weights;

  // data structs for looking up nearest photons
  int maxNphotons;
  ANNdistArray distances;
  ANNidxArray nearestPoints;
  ANNpoint annReferencePoint;
  Photon **nearestPhotons;
};

#endif
