
#ifndef LIGHT_H
#define LIGHT_H
#include "lrt.h"
#include "geometry.h"
#include "transform.h"
#include "color.h"
#include "shading.h"

typedef enum
  {
    None, IsotropicPoint
  } LightType;

class LightAttributes:public ReferenceCounted {
  public:

	LightAttributes() {

		CastsShadows = false;
		NSamples = 1;

	} bool CastsShadows;
	int NSamples;

	Transform WorldToLight, LightToWorld;

};

class Light { public:
	// HCL
	LightType type;

	 Light(SurfaceFunction * ud, LightAttributes * attr)
	:attributes(attr), surfaceFunction(ud) {
	   type = None;
	} virtual ~ Light();

	bool CastsShadows() const {
		return attributes->CastsShadows;
	} virtual Spectrum dE(const Point & Pshade, Point * Plight) const = 0;

	int NumSamples() const {
		return attributes->NSamples;
	} virtual const Primitive *GetPrimitive() const {
		return NULL;
  } protected:

	 LightAttributes * attributes;
	SurfaceFunction *surfaceFunction;
};

class IsotropicPointLight:public Light {
  public:

	IsotropicPointLight(SurfaceFunction * ud, LightAttributes * attr);

	Spectrum dE(const Point & Ps, Point * Plight) const;

	// private:
	 Spectrum I;
	Point lightPos;

};

class DirectionalLight:public Light { public:
	 DirectionalLight(SurfaceFunction * ud, LightAttributes * attr);

	Spectrum dE(const Point &, Point * Plight) const;

  private:
	 Spectrum I;
	Vector lightDir;

};

class SpotLight:public Light { public:
	 SpotLight(SurfaceFunction * ud, LightAttributes * attr);

	Spectrum dE(const Point & Ps, Point * Plight) const;

  private:
	 Spectrum I;
	Point pFrom, pTo;
	Vector lightDir;

	Float coneAngle, coneDeltaAngle, beamDistribution;

};

class AmbientLight { public:
	 AmbientLight(SurfaceFunction * ud, LightAttributes * attr);

	~AmbientLight();

	Spectrum Intensity(const Point & Ps) const;

  private:
	 Spectrum I;
	LightAttributes *attributes;
	SurfaceFunction *surfaceFunction;

};

class AreaLight:public Light { public:
	AreaLight(SurfaceFunction * ud, LightAttributes * attr);

	void SetGeometry(const Primitive * prim) {
		if (primitive != NULL) {
			Severe("Only one primitive per area light allowed.");
		}
		primitive = prim;
	} const Primitive *GetPrimitive() const {
		return primitive;
	} virtual Spectrum Le(const ShadeContext & sc) const = 0;

  protected:

	const Primitive *primitive;

};

class DiffuseAreaLight:public AreaLight { public:
	DiffuseAreaLight(SurfaceFunction * ud, LightAttributes * attr);

	Spectrum Le(const ShadeContext &) const;

	Spectrum dE(const Point & Pshade, Point * Plight) const;

  private:
	 Spectrum Lo;

};

#endif // LIGHT_H
