#include "bumpmap.h"
#include "color.h"
#include "geometry.h"
#include "sl.h"

// The larger the FILTER_SIZE, the wider the bevel will be.
#define FILTER_SIZE 3

// The smaller the BEVEL_SHARPNESS, the sharper the bevel will be.
#define BEVEL_SHARPNESS 1.5

BumpMap::BumpMap(const char *filename)
{
  bumpMap = TIFFRead(filename, &width, &height);
}

BumpMap::~BumpMap()
{
  delete[] bumpMap;
}

Normal BumpMap::GetNormal(Float u, Float v)
{
  if (!bumpMap)
    return Normal(0, 0, 0);

  u = Clamp(u, 0, 1);
  v = Clamp(v, 0, 1);

  int x = (int) (u * (width - 1));
  int y = (int) (v * (height - 1));
  if (x < FILTER_SIZE || x > width - FILTER_SIZE - 1 || y < FILTER_SIZE || y > height - FILTER_SIZE - 1)
    return Normal(0, 0, 0);

  Spectrum mapNormalX;
  for (int sampleX = -FILTER_SIZE; sampleX <= FILTER_SIZE; sampleX++)
    for (int sampleY = -FILTER_SIZE; sampleY <= FILTER_SIZE; sampleY++)
      {
	if (sampleX < 0)
	  mapNormalX = mapNormalX + bumpMap[(y + sampleY) * width + x + sampleX];
	else if (sampleX > 0)
	  mapNormalX = mapNormalX - bumpMap[(y + sampleY) * width + x + sampleX];
      }
  SLTriple xTriple(mapNormalX / ((Float) (FILTER_SIZE * FILTER_SIZE * 4)));
  
  Spectrum mapNormalY;
  for (int sampleX = -FILTER_SIZE; sampleX <= FILTER_SIZE; sampleX++)
    for (int sampleY = -FILTER_SIZE; sampleY <= FILTER_SIZE; sampleY++)
      {
	if (sampleY > 0)
	  mapNormalY = mapNormalY + bumpMap[(y + sampleY) * width + x + sampleX];
	else if (sampleY < 0)
	  mapNormalY = mapNormalY - bumpMap[(y + sampleY) * width + x + sampleX];
      }
  SLTriple yTriple(mapNormalY / ((Float) (FILTER_SIZE * FILTER_SIZE * 4)));

  Float mapNormalXIntensity = ((xTriple.a + xTriple.b + xTriple.c) / BEVEL_SHARPNESS);
  Float mapNormalYIntensity = ((yTriple.a + yTriple.b + yTriple.c) / BEVEL_SHARPNESS);
  Normal mapNormal(mapNormalXIntensity, mapNormalYIntensity, 0);

  return mapNormal;
}
