#include "/usr/class/cs248/support/include/GL/glut.h"
#include <stdlib.h>
#include <stdio.h>


GLfloat hangle = 0.0, vangle = 0.0;
GLuint lists[1000];
int forDisplay=-1;

void display()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glCallList(lists[forDisplay]); 
	glutSwapBuffers(); 	
}

int equals(char *first, char *second)
{
	char *firstpointer = first;
	char *secondpointer = second;
	while ((*firstpointer != '\0') && (*secondpointer != '\0'))
	{
		if (*firstpointer++ != *secondpointer++)
			return 0;
		if (((*firstpointer == '\0') && (*secondpointer != '\0')) ||
			((*firstpointer != '\0') && (*secondpointer == '\0')))
			return 0;
	}
	return 1;
}

void readInObject(char *filename)
{
	FILE *fp;
	char *command = "";
	char fc;
	int object = 0, total_objects, end;
	int j;
	float arg1, arg2, arg3, arg4;
	int arg5, arg6;
	
	if( (fp = fopen(filename, "r")) == NULL) {
    	printf("error: cannot open this file\n");
    	exit(1);
  	}
  	/*fscanf(fp, "%d%d", &total_objects, &forDisplay);*/
  	for (;;)
  	{
  	        fscanf(fp,"%s %d",command,&object);
  	        if (equals(command,"ENDFILE"))
  	        {
  	            if (forDisplay == -1) forDisplay = object;
  	            fclose (fp);
  	            return;
  	        }
  	        else if (equals(command,"MAIN")) forDisplay = object;
  		lists[object] = glGenLists(1);
  		end = 0;
  		glNewList(lists[object], GL_COMPILE);
  			while (end == 0)
  			{
  				fscanf(fp, "%s", command);
  				fc = *command;
  				if (fc!='#'){
  				if (equals(command, "PUSH"))
  					glPushMatrix();
  				else if (equals(command, "POP"))
  					glPopMatrix();
  				else if (equals(command, "CALL"))
  				{
  					fscanf(fp, "%d", &arg5);
  					glCallList(lists[arg5]);
  				}
  				else if ((equals(command, "POLYGON")) || 
  					(equals(command, "LINE"))) 
  				{
  					if (equals(command, "POLYGON"))
  					{
  						fscanf(fp, "%d%d", &arg5, &arg6);
  						glBegin(GL_POLYGON);
  					}
  					else
  					{
  						fscanf(fp, "%d", &arg6);
  						glBegin(GL_LINES);
  						arg5 = 2;
  					}
  					for (j = 0; j < arg5; j++)
  					{
  						if (arg6 == 1)
  						{
  							fscanf(fp, "%f%f%f", &arg1, &arg2, &arg3);
  							glColor3f(arg1, arg2, arg3);
  						}
  						fscanf(fp, "%f%f%f", &arg1, &arg2, &arg3);
  						glVertex3f(arg1, arg2, arg3); 
  					}
  					glEnd();
  				}	
  				else if (equals(command, "ENDLIST"))
  					end = 1;
  				else
  				{
  					fscanf(fp, "%f%f%f", &arg1, &arg2, &arg3);
  					if (equals(command, "COLOR"))
  						glColor3f(arg1, arg2, arg3);
  					else if (equals(command, "TRANSLATE"))
  						glTranslatef(arg1, arg2, arg3);
  					else if (equals(command, "SCALE"))
  						glScalef(arg1, arg2, arg3);
  					else if (equals(command, "ROTATE"))
  					{
  						fscanf(fp, "%f", &arg4);
  						glRotatef(arg1, arg2, arg3, arg4);
  					}
  				}
  				}			
  			}
  		glEndList();
  	}
}

void keyboard(unsigned char key, int x, int y)
{
	switch(key)
	{
		case 'a':
		case 'A':
			if (vangle > -90.0)
			{
				glRotatef(-hangle, 0.0, 1.0, 0.0); 
				glRotatef(-1.0, 1.0, 0.0, 0.0);
				glRotatef(hangle, 0.0, 1.0, 0.0); 
				vangle -= 1.0;
			}
			break;
		case 'z':
		case 'Z':
			if (vangle < 90.0)
			{
				glRotatef(-hangle, 0.0, 1.0, 0.0); 
				glRotatef(1.0, 1.0, 0.0, 0.0);
				glRotatef(hangle, 0.0, 1.0, 0.0); 
				vangle += 1.0;
			}
			break;
		case '<':
		case ',':
			glRotatef(1.0, 0.0, 1.0, 0.0);
			hangle += 1.0;
			break;
		case '>':
		case '.':
			glRotatef(-1.0, 0.0, 1.0, 0.0);
			hangle -= 1.0;
			break;	
		case '_':
		case '-':
			glRotatef(-hangle, 0.0, 1.0, 0.0);
			glRotatef(-vangle, 1.0, 0.0, 0.0);
			glTranslatef(0.0, 0.0, 1.0);
			glRotatef(vangle, 1.0, 0.0, 0.0);
			glRotatef(hangle, 0.0, 1.0, 0.0);
			break;
		case '+':
		case '=':
			glRotatef(-hangle, 0.0, 1.0, 0.0);
			glRotatef(-vangle, 1.0, 0.0, 0.0);
			glTranslatef(0.0, 0.0, -1.0);
			glRotatef(vangle, 1.0, 0.0, 0.0);
			glRotatef(hangle, 0.0, 1.0, 0.0);
	}	
	glutPostRedisplay();
}

void init()
{
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glClearDepth(1.0);
	glEnable(GL_DEPTH_TEST);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(-2.5, 2.5, -2.5, 2.5, 4.0, 500.0);
	gluLookAt(0.0, 0.0, -50.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	glMatrixMode(GL_MODELVIEW); 
}

int main (int argc, char **argv)
{
	char **dummy = NULL;
	int num = 0;
	glutInit(&num, dummy);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(500, 500);
	glutInitWindowPosition(100, 100);
	glutCreateWindow("2DL Viewer");
	init();
	readInObject(argv[1]);
	glutDisplayFunc(display);
	glutKeyboardFunc(keyboard);
	glutMainLoop();
	return 0;
} 
