varying vec2 texCoord;
varying vec4 color;

void main() {
    vec3 normal, lightDir;
    vec4 position;
    float NdotL, NdotHV;
    vec4 ambient, diffuse, specular;

    normal = normalize(gl_NormalMatrix * gl_Normal);

    position = gl_ModelViewMatrix * gl_Vertex;     

    lightDir = normalize(vec3(gl_LightSource[0].position - position));

    NdotL = max(dot(normal, lightDir), 0.0);
    NdotHV = max(dot(normal, vec3(gl_LightSource[0].halfVector)), 0.0);

	ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
    diffuse = gl_FrontMaterial.diffuse * NdotL * gl_LightSource[0].diffuse;
    specular = gl_FrontMaterial.specular * gl_LightSource[0].specular * NdotHV;

    gl_FrontColor = gl_FrontLightModelProduct.sceneColor + 
		ambient +
		diffuse +
		specular;
	color = gl_FrontColor;

    gl_Position = gl_ProjectionMatrix * position;

    //texCoord = vec2(gl_MultiTexCoord0);
}
