/*
 * 
 * main() for the Game
 * should only contain startup logic 
 *
 *
 */

#include <SDL_opengl.h>
#include <SDL.h>
#include <SDL_mixer.h>
#include <SDL_ttf.h>
#include <iostream>

#include "Display.h"
#include "TitleScreen.h"
#include "GameWorld.h"
#include "GameLoop.h"
#include "Vec3f.h"
#include "SurfaceUtil.h"
#include "MiniMap.h"

using namespace std;

bool debugMode = false;
bool musicMode = false;
bool statsMode = false;
bool multitextureMode = false;

/*
 * initialize display, create game, start game loop
 */
int main(int argc, char **argv) {
    // game startup params and defaults
    unsigned int gameMinutes = 10;
    unsigned int cows = 10;
    
    // process argument flags
    if (argc > 0) {
        for (int i = 0; i < argc; i++) {
            if (argv[i][0] == '-') {
                switch(argv[i][1]) {
                    case 'd':
                        // set debug mode on
                        debugMode = true;
                        break;
                    case 'm':
                        // set music mode on
                        musicMode = true;
                        break;
                    case 's':
                        // set stats mode on
                        statsMode = true;
                        break;
                    case 't':
                        // set multitexturing mode on
                        multitextureMode = true;
                        break;
                        
                    case 'c':
                        // num cows
                        cows = atoi(&argv[i][2]);
                        break;
                        
                    case 'i':
                        // game time
                        gameMinutes = atoi(&argv[i][2]);
                        break;
                        
                    default:
                        cout << "Unknown options " << argv[i] << endl;
                }
            }
        }
    }
    
    // init a display window
    Display::init();
    
    // init surface utilities
    SurfaceUtil::init();
    
    if (statsMode) {
	   cout << "OpenGL Version is: " << glGetString(GL_VERSION) << endl;
    }
    
    // draw title screen
    TitleScreen* titleScreen = new TitleScreen();
    titleScreen->drawLoadingScreen();
    
    // create a game world
    GameWorld* gameWorld = new GameWorld(cows);
    
    // create a game loop
    GameLoop* gameLoop = new GameLoop(*gameWorld);
    gameWorld->setGameLoop(gameLoop);
    
    // draw title screen start text after game has initialized and handle events
    titleScreen->drawStartScreen();
    titleScreen->handleEvents();
    delete titleScreen;
    
    // setup game and start loop
    gameWorld->setGameIsRunning(true);
    gameWorld->getMiniMap()->setTotalTime( gameMinutes * 60 * 1000 );
    gameWorld->getMiniMap()->setStartTime(SDL_GetTicks());
    gameLoop->start();
 
    // these will probably never be reached
    delete gameWorld;
    delete gameLoop;

    return 0;   
}
